/*
 * ConsecutiveExecuteThread.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.consecutiveexecuter;

/**
 * @author macchan
 * @version $Id: ConsecutiveExecuteThread.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class ConsecutiveExecuteThread implements Runnable {

	private static final int RUNNING = 1;
	private static final int STOPPED = 2;

	private int state = STOPPED;
	private ConsecutiveExecuteComponent component = null;
	private Thread thread = null;

	/**
	 * Constructor for ConsecutiveExecuteThread.
	 */
	public ConsecutiveExecuteThread(ConsecutiveExecuteComponent component) {
		this.component = component;
		this.setState(STOPPED);
	}

	public void doTransitition() {
		if (this.state == RUNNING) {
			this.stop();
		}
		else if (this.state == STOPPED) {
			this.start();
		}
	}

	public synchronized void start() {
		if (this.state == RUNNING) {
			return;
		}

		this.thread = new Thread(this);
		this.thread.start();
	}

	public synchronized void stop() {
		if (this.state == STOPPED) {
			return;
		}

		this.thread.interrupt();
	}

	private synchronized void setState(int state) {
		this.state = state;
		if (this.state == RUNNING) {
			this.component.setClosable(false);
			this.component.buttonRun.setText("s");
		}
		else if (this.state == STOPPED) {
			this.component.setClosable(true);
			this.component.buttonRun.setText("s!");
		}
	}

	public void run() {
		try {
			this.setState(RUNNING);
			this.component.run();
		}
		catch (Exception ex) {
		}
		finally {
			this.thread = null;
			this.setState(STOPPED);
		}
	}

}
