/*
 * ControlManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.guifw.ShowGUIComponentAction;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;

/**
 * ǂ鐧}l[Wł
 * @author macchan
 * @version $Id: ControlManager.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class ControlManager
	extends AbstractPresentationComponent
	implements SimulationStateListener, ModelContainerListener {

	private static final Logger logger =
		Logger.getLogger(ControlManager.class.getName());

	public static ResourceBundle resource = ControlManagerPlugin.resource;

	/*****************************************
	 * tB[h
	 *****************************************/

	private ControlPanel controlPanel = null;

	/*****************************************
	 * j[֘A
	 *****************************************/

	//䃁j[
	public Menu controlMenu = new Menu();

	//O[v
	public ActionGroup controlGroup = new ActionGroup();
	public Action runAction = new RunAction();
	public Action stopAction = new StopAction();
	public Action stepRunAction = new LimitedTimeRunAction();
	public Action resetAction = new ResetAction();

	//\/pl\O[v
	public ActionGroup showControlPanelGroup = new ActionGroup();
	public Action showControlPanelAction = null;

	/*****************************************
	 * RXgN^
	 *****************************************/

	/**
	 * Constructor for ControlManager.
	 */
	public ControlManager() {
		super();
	}

	/***************************************
	 * 
	 ***************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeControlPanel();
		this.initializeControlMenu();
		this.initializeShowMenu();
	}

	private void initializeControlPanel() {
		this.controlPanel = new ControlPanel(this);
		this.getPresentationContainer().addPresentationComponent(controlPanel);
		this.controlPanel.show();
	}
	private void initializeControlMenu() {
		//j[̒ǉ
		this.getPresentationContainer().getMenuManager().controlMenuGroup.add(
			this.controlMenu);
		this.controlMenu.setName(resource.getString("Menu_Control"));

		//O[v̒ǉ
		this.controlMenu.add(this.controlGroup);

		//Rg[O[ṽANV̒ǉ
		this.controlGroup.add(this.runAction);
		this.controlGroup.add(this.stepRunAction);
		this.controlGroup.add(this.stopAction);
		this.controlGroup.add(this.resetAction);
	}

	private void initializeShowMenu() {
		//O[v̒ǉ
		this.getPresentationContainer().getGuiContainer().showFirstGroup.add(
			this.showControlPanelGroup);

		//pl\ANV̐Aǉ
		this.showControlPanelAction =
			new ShowGUIComponentAction(
				resource.getString("Menu_ControlPanel"),
				this.controlPanel);
		this.showControlPanelGroup.add(this.showControlPanelAction);
	}

	/***************************************
	 * I
	 ***************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/***************************************
	 * Rg[pl֘A
	 ***************************************/

	/**
	 * Returns the controlPanel.
	 * @return ControlPanel
	 */
	public ControlPanel getControlPanel() {
		return controlPanel;
	}

	/***************************************
	 * ԑJڊ֘A
	 ***************************************/

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		this.runAction.setEnabled(false);
		this.stepRunAction.setEnabled(false);
		this.stopAction.setEnabled(true);
		this.resetAction.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
		this.stopAction.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		this.runAction.setEnabled(true);
		this.stepRunAction.setEnabled(true);
		this.stopAction.setEnabled(false);
		this.resetAction.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.runAction.setEnabled(true);
		this.stepRunAction.setEnabled(true);
		this.stopAction.setEnabled(false);
		this.resetAction.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.controlGroup.setEnabled(false);
	}

}
