/*
 * ControlPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.besp.presentation.bface.menu.Action;

/**
 * ModelThread̏Ԃplŕ\A܂ModelThread𐧌䂷plłB
 * 
 * @author macchan
 * @version $Id: ControlPanel.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class ControlPanel
	extends AbstractInternalFrameComponent
implements /*ParetteLayerInternalFrame,*/
SimulationStateListener, ModelContainerListener {

	private static final Logger logger =
		Logger.getLogger(ControlPanel.class.getName());

	//\[X
	public static ResourceBundle resource = ControlManagerPlugin.resource;

	public static final String TITLE = resource.getString("Title_ControlPanel");
	public static final String SPACE = " - ";
	public static final String TITLE_RUNNING =
		TITLE + SPACE + resource.getString("Title_Running");
	public static final String TITLE_STOPPING =
		TITLE + SPACE + resource.getString("Title_Stopping");
	public static final String TITLE_STOPPED =
		TITLE + SPACE + resource.getString("Title_Stopped");
	public static final String LABEL_NOWORLD =
		resource.getString("Label_NoWorld");
	public static final String BUTTON_EXTEND =
		resource.getString("Button_Extend");

	//傫
	//private static final int WIDTH = 300;
	private static final int CONTROL_BUTTON_HEIGHT = 40;
	private static final int CONTROL_BUTTON_WIDTH = 40;
	private static final Color CONTROL_BUTTON_BGCOLOR = Color.gray;
	private static final int EXTEND_BUTTON_HEIGHT = 20;
	private static final int EXTEND_BUTTON_WIDTH = 20;

	//Rg[}l[W
	private ControlManager controlManager = null;

	//pl̊g̏
	private boolean isExtended = false;

	//gpl
	private JPanel extendPanel = new JPanel();

	//LabelQ
	private JLabel labelWorldName = new JLabel();

	/**
	 * RXgN^
	 */
	public ControlPanel(ControlManager controlManager) {
		this.controlManager = controlManager;
	}

	/****************************************
	 * iI[o[Chj
	 *****************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent#initializeDefaultCloseOperation()
	 */
	protected void initializeDefaultCloseOperation() {
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent#initializeFrame()
	 */
	protected void initializeFrame() {
		super.initializeFrame();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent#initializeFramePolicy()
	 */
	protected void initializeFramePolicy() {
		this.setIconifiable(false);
		//this.setResizable(false);
		this.setClosable(true);
		this.setMaximizable(false);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent#initializeIcon()
	 */
	protected void initializeIcon() {
		super.initializeIcon();
	}

	/****************************************
	 * 
	 *****************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.getContentPane().setBackground(Color.white);

		this.getContentPane().add(
			this.createWorldNamePanel(),
			BorderLayout.NORTH);
		this.getContentPane().add(
			this.createControlButtonPanel(),
			BorderLayout.CENTER);
		this.getContentPane().add(
			this.createExtendButtonPanel(),
			BorderLayout.EAST);

		//Ԃ	
		this.worldClosed(null);

		this.initializeSize();
		this.initializeLocation();
	}

	/**
	 * E\pl𐶐
	 */
	private JPanel createWorldNamePanel() {
		JPanel panel = new JPanel();
		panel.add(this.labelWorldName);
		return panel;
	}

	/**
	 * 4̐{^Cpl𐶐
	 */
	private JPanel createControlButtonPanel() {
		JPanel panel = new JPanel();
		panel.add(this.createControlButton(this.controlManager.runAction));
		panel.add(this.createControlButton(this.controlManager.stepRunAction));
		panel.add(this.createControlButton(this.controlManager.stopAction));
		panel.add(this.createControlButton(this.controlManager.resetAction));
		return panel;
	}

	/**
	 * Action琧{^𐶐
	 */
	private JButton createControlButton(Action action) {
		JButton button = new JButton(action);
		button.setPreferredSize(
			new Dimension(CONTROL_BUTTON_HEIGHT, CONTROL_BUTTON_WIDTH));
		button.setBackground(CONTROL_BUTTON_BGCOLOR);
		button.setText(null);
		button.setIcon(action.getIcon());
		return button;
	}

	/**
	 * g{^pl𐶐
	 */
	private JPanel createExtendButtonPanel() {
		//pl
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());

		//{^
		JButton button = new JButton();
		button.setMargin(new Insets(0, 0, 0, 0));
		button.setText(BUTTON_EXTEND);
		button.setPreferredSize(
			new Dimension(EXTEND_BUTTON_HEIGHT, EXTEND_BUTTON_WIDTH));
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				transitExtentionState();
			}
		});

		//iǉ
		panel.add(button, BorderLayout.SOUTH);
		return panel;
	}

	/****************************************
	 * i傫ƈʒuj
	 *****************************************/

	/**
	 * 傫܂
	 */
	private void initializeSize() {
		this.validate();
		int width = this.getPreferredSize().width;
		int height = this.getPreferredSize().height;
		this.setSize(width, height);
	}

	/**
	 * ʒu܂
	 */
	private void initializeLocation() {
		int wMargin = 50;
		int hMargin = 50;
		int windowWidth = this.getMainFrame().getSize().width;
		int width = this.getSize().width;
		this.setLocation(windowWidth - width - wMargin, hMargin);
	}

	/****************************************
	 * I
	 *****************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/****************************************
	 * g
	 *****************************************/

	private void transitExtentionState() {
		if (this.isExtended) {
			this.deExtend();
		} else {
			this.extend();
		}
		this.isExtended = !this.isExtended;
	}

	private void extend() {
		this.getContentPane().add(this.extendPanel, BorderLayout.SOUTH);
		this.initializeSize();
	}

	private void deExtend() {
		this.getContentPane().remove(this.extendPanel);
		this.initializeSize();
	}

	/**
	 * gplCXg[܂
	 */
	public void installExtendPanel(JPanel panel) {
		this.extendPanel.add(panel);
	}

	/****************************************
	 * ԑJڊ֘A
	 *****************************************/

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.labelWorldName.setText(this.getWorld().getName());
		this.initializeSize();
	}
	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.labelWorldName.setText(LABEL_NOWORLD);
		this.setTitle(TITLE);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		this.setTitle(TITLE_RUNNING);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		this.setTitle(TITLE_STOPPED);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
		this.setTitle(TITLE_STOPPING);
	}

}
