/*
 * LimitedTimeRunAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.LimitedTimeRunCommand;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: LimitedTimeRunAction.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class LimitedTimeRunAction extends Action {

	/**
	 * Constructor for LimitedTimeRunAction.
	 */
	public LimitedTimeRunAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(
			ControlManagerPlugin.resource.getString("Menu_LimitedTimeRun"));
		this.setIcon(
			GUIUtility.createIcon("image/limitedtimerun.gif", this.getClass()));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_K, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		new LimitedTimeRunCommand(this.getContainer()).execute();
	}

}
