/*
 * ResetAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.awt.event.KeyEvent;

import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.ResetCommand;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: ResetAction.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class ResetAction extends Action {

	/**
	 * Constructor for ResetAction.
	 */
	public ResetAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(ControlManagerPlugin.resource.getString("Menu_Reset"));
		this.setIcon(GUIUtility.createIcon("image/reset.gif", this.getClass()));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_SEMICOLON, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		if (!this.confirm()) {
			return; //LZꂽ
		}
		new ResetCommand(this.getContainer()).execute();
	}

	/**
	 * Comfirm܂B
	 */
	public boolean confirm() {
		int result =
			JOptionPane.showConfirmDialog(
				this.getPresentationContainer().getMainFrame(),
				"Any change is ignored. OK?",
				"Reset",
				JOptionPane.OK_CANCEL_OPTION);

		if (result == JOptionPane.OK_OPTION) {
			return true;
		}
		else {
			return false;
		}
	}

}
