/*
 * RunAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.RunCommand;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: RunAction.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class RunAction extends Action {

	/**
	 * Constructor for RunAction.
	 * @param name
	 */
	public RunAction() {
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(ControlManagerPlugin.resource.getString("Menu_Run"));
		this.setIcon(GUIUtility.createIcon("image/run.gif", this.getClass()));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_J, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.MenuElement#doAction()
	 */
	protected void doAction() throws Exception {
		new RunCommand(this.getContainer()).execute();
	}

}
