/*
 * StopAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.control;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.StopCommand;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: StopAction.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class StopAction extends Action {

	/**
	 * Constructor for StopAction.
	 */
	public StopAction() {
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(ControlManagerPlugin.resource.getString("Menu_Stop"));
		this.setIcon(GUIUtility.createIcon("image/stop.gif", this.getClass()));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_L, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.MenuElement#doAction()
	 */
	protected void doAction() throws Exception {
		new StopCommand(this.getContainer()).execute();
	}

}
