/*
 * ExitAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.file;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.presentation.bface.menu.Action;

/**
 * @author macchan
 * @version $Id: ExitAction.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class ExitAction extends Action {

	/**
	 * Constructor for ExitAction.
	 */
	public ExitAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(FileManagerPlugin.resource.getString("Menu_Exit"));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_Q, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		BESP.terminate();
	}

}
