/*
 * FileManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.file;

import java.util.ResourceBundle;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;

/**
 * t@C(j[)ǗNXł
 * @author macchan
 * @version $Id: FileManager.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class FileManager
	extends AbstractPresentationComponent
	implements ModelContainerListener, SimulationStateListener {

	public static ResourceBundle resource = FileManagerPlugin.resource;

	/************************************************
	 * j[֘A
	 ************************************************/

	public Menu fileMenu = new Menu();
	public ActionGroup fileOperationGroup = new ActionGroup();
	public ActionGroup importGroup = new ActionGroup();
	public Menu importMenu = new Menu(resource.getString("Menu_Import"));
	public ActionGroup exitGroup = new ActionGroup();

	public Action fileOpenAction = new FileOpenAction();
	public Action fileSaveAction = new FileSaveAction();
	public Action fileSaveAsAction = new FileSaveAsAction();
	public Action importWorldAction = new ImportWorldAction();
	public Action exitAction = new ExitAction();

	/************************************************
	 * RXgN^
	 ************************************************/

	/**
	 * Constructor for FileManager.
	 */
	public FileManager() {
		super();
	}

	/************************************************
	 * 
	 ************************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeFileMenu();
	}

	private void initializeFileMenu() {
		//j[̐ݒ
		this.getPresentationContainer().getMenuManager().fileMenuGroup.add(
			this.fileMenu);
		this.fileMenu.setName(resource.getString("Menu_File"));

		//O[v̒ǉ
		this.fileMenu.add(this.fileOperationGroup);
		this.fileMenu.add(this.importGroup);
		this.fileMenu.add(this.exitGroup);

		//t@CO[ṽANV
		this.fileOperationGroup.add(this.fileOpenAction);
		this.fileOperationGroup.add(this.fileSaveAsAction);
		this.fileOperationGroup.add(this.fileSaveAction);

		//ImportO[v̂ƃANV
		this.importGroup.add(this.importMenu);
		this.importGroup.add(this.importMenu);
		this.importMenu.add(this.importWorldAction);

		//IO[ṽANV
		this.exitGroup.add(this.exitAction);
	}

	/************************************************
	 * I
	 ************************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/********************************
	 * ԑJڊ֘A
	 ********************************/

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.fileSaveAction.setEnabled(true);
		this.fileSaveAsAction.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.fileSaveAction.setEnabled(false);
		this.fileSaveAsAction.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		this.fileOperationGroup.setEnabled(false);
		this.importWorldAction.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		this.fileOperationGroup.setEnabled(true);
		this.importWorldAction.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
	}

}
