/*
 * FileOpenAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.file;

import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.FileOpenCommand;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: FileOpenAction.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class FileOpenAction extends Action {

	/**
	 * Constructor for FileOpenAction.
	 */
	public FileOpenAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(FileManagerPlugin.resource.getString("Menu_Open"));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_O, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		File file = this.selectFile();

		if (file == null) {
			return; //LZꂽ
		}
		
		System.out.println(file.getName());
		System.out.println(file.getAbsolutePath());		
		new FileOpenCommand(this.getContainer(), file).execute();
	}

	/**
	 * _CAOoāAt@CI܂
	 */
	private File selectFile() throws Exception {
		File selectedFile =
			GUIUtility.chooseOpenFile(
				this.getPresentationContainer().getMainFrame());

		return selectedFile;
	}

}
