/*
 * FileSaveAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.file;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.command.FileSaveCommand;

/**
 * @author macchan
 * @version $Id: FileSaveAction.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class FileSaveAction extends FileSaveAsAction {

	/**
	 * Constructor for FileSaveAction.
	 */
	public FileSaveAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(FileManagerPlugin.resource.getString("Menu_Save"));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_S, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		//At@Cݒ肳ĂȂ΁ASaveAs
		if (this.getModelContainer().getFile() == null) {
			super.doAction();
			return;
		}

		new FileSaveCommand(this.getContainer()).execute();
	}

}
