/*
 * ImportWorldAction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.file;

import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.command.ImportWorldCommand;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * @author macchan
 * @version $Id: ImportWorldAction.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class ImportWorldAction extends Action {

	/**
	 * Constructor for ImportWorldAction.
	 */
	public ImportWorldAction() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
		this.setName(FileManagerPlugin.resource.getString("Menu_ModelCreator"));
		this.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_W, KeyEvent.CTRL_MASK));
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		String className = this.selectClass();
		if (className == null) {
			return; //LZꂽ
		}

		new ImportWorldCommand(this.getContainer(), className).execute();
	}

	/**
	 * _CAOoāA[UɃNXI܂
	 */
	public String selectClass() {
		String className =
			GUIUtility.showBoxClassTreeDialog(
				BESP.classTreeRoot.createSubTree(World.class),
				FileManagerPlugin.resource.getString("Title_ImportModelCreator"),
				this.getPresentationContainer().getMainFrame());
		return className;
	}

}
