/*
 * HelpManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.help;

import java.util.ResourceBundle;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.guifw.ShowDialogAction;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;

/**
 * wvǗNX
 * ܂About_CAOĂ܂
 * ̃pbP[WHelpVXet[[NƂčg\ł
 * @author macchan
 * @version $Id: HelpManager.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class HelpManager extends AbstractPresentationComponent {

	public static ResourceBundle resource = HelpManagerPlugin.resource;

	/******************************************
	 * j[֘A
	 ******************************************/

	public Menu helpMenu = new Menu();
	public ActionGroup helpGroup = new ActionGroup();
	public ShowDialogAction showAboutDialogAction = new ShowDialogAction();

	/******************************************
	 * RXgN^
	 ******************************************/

	/**
	 * Constructor for HelpManager.
	 */
	public HelpManager() {
		super();
	}

	/******************************************
	 * 
	 ******************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeHelpMenu();
	}

	private void initializeHelpMenu() {
		//j[̓o^
		this.getPresentationContainer().getMenuManager().helpMenuGroup.add(
			this.helpMenu);
		this.helpMenu.setName(resource.getString("Menu_Help"));

		//O[v̓o^
		this.helpMenu.add(this.helpGroup);

		//About_CAO̓o^
		AboutDialog aboutDialog =
			new AboutDialog(
				this.getPresentationContainer().getMainFrame(),
				BESP.COPYRIGHT);
		this.showAboutDialogAction.setDialog(aboutDialog);
		this.showAboutDialogAction.setName(
			resource.getString("Menu_AboutDialog"));
		this.helpGroup.add(this.showAboutDialogAction);
	}

	/******************************************
	 * I
	 ******************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

}
