/*
 * LanguageResource.java
 * Created on 2004/06/06
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.language;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Class LanguageResource.
 * 
 * @author macchan
 * @version $Id: LanguageResource.java,v 1.1 2004/06/07 05:38:08 macchan Exp $
 */
public class LanguageResource {

	private static final String BUNDLE_NAME = "org.boxed_economy.components.language.resource"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE =
		ResourceBundle.getBundle(BUNDLE_NAME);

	/**
	 * Constructor for LanguageResource.
	 */
	private LanguageResource() {

	}
	public static String get(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
}
