/*
 * LanguageSelectionPanel.java
 * Created on 2004/06/06
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.language;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.JComboBox;
import javax.swing.JLabel;

import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;

import org.boxed_economy.besp.container.ArgumentManager;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.property.PropertyPanel;

/**
 * Class LanguageSelectionPanel.
 * 
 * @author macchan
 * @version $Id: LanguageSelectionPanel.java,v 1.2 2004/06/07 05:38:08 macchan Exp $
 */
public class LanguageSelectionPanel extends PropertyPanel {

	private static final String DEFAULT_LANGUAGE_KEY = "default"; //$NON-NLS-1$
	private static final Map LANGUAGES = new LinkedHashMap();
	private static final Map LANGUAGE_KEYS = new LinkedHashMap();
	static {
		installLanguage(DEFAULT_LANGUAGE_KEY, LanguageResource.get("LanguageSelectionPanel.Default")); //$NON-NLS-1$
		installLanguage("ja", LanguageResource.get("LanguageSelectionPanel.Japanese")); //$NON-NLS-1$ //$NON-NLS-2$
		installLanguage("en", LanguageResource.get("LanguageSelectionPanel.English")); //$NON-NLS-1$ //$NON-NLS-2$
	}
	private static void installLanguage(String key, String name) {
		LANGUAGES.put(key, name);
		LANGUAGE_KEYS.put(name, key);
	}

	private JLabel label = new JLabel();
	private JComboBox comboBox = new JComboBox();

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#initialize()
	 */
	public void initialize() {
		//Set title
		setTitle(LanguageResource.get("LanguageSelectionPanel.Language")); //$NON-NLS-1$

		//Sets Label
		label.setText(LanguageResource.get("LanguageSelectionPanel.Valid_Message")); //$NON-NLS-1$

		//Sets Combobox;
		for (Iterator i = LANGUAGES.values().iterator(); i.hasNext();) {
			comboBox.addItem(i.next());
		}

		//Adds
		setLayout(new VerticalFlowLayout());
		add(label);
		add(comboBox);
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		if (hasFile()) {
			String locale = readFile();
			if (hasLocale(locale)) {
				comboBox.setSelectedItem(LANGUAGES.get(locale));
			}
		}
	}

	private boolean hasFile() {
		return getFile().exists();
	}

	private File getFile() {
		File file = new File(BESP.boxHome, ArgumentManager.LOCALE_FILENAME);
		return file;
	}

	private String readFile() {
		try {
			BufferedReader br = new BufferedReader(new FileReader(getFile()));
			String locale = br.readLine();
			br.close();
			return locale;
		} catch (Exception ex) {
			return null;
		}
	}

	private void writeFile(String locale) {
		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(getFile()));
			bw.write(locale);
			bw.close();
		} catch (Exception ex) {
			return;
		}
	}

	private void deleteFile() {
		if (hasFile()) {
			getFile().delete();
		}
	}

	private boolean hasLocale(String locale) {
		return LANGUAGES.get(locale) != null;
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		String key = (String) LANGUAGE_KEYS.get(comboBox.getSelectedItem());
		if (key.equals(DEFAULT_LANGUAGE_KEY)) {
			deleteFile();
		} else {
			writeFile(key);
		}
	}

}
