/*
 * LanguageSelectionPlugin.java
 * Created on 2004/06/06
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.language;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.components.property.PropertyManager;
import org.boxed_economy.components.property.PropertyManagerPlugin;

/**
 * Class LanguageSelectionPlugin.
 * 
 * @author macchan
 * @version $Id: LanguageSelectionPlugin.java,v 1.1 2004/06/07 04:35:46 macchan Exp $
 */
public class LanguageSelectionPlugin implements BESPPlugin {

	public static void initializePlugin(BESPContainer container) {
		PropertyManager manager =
			(PropertyManager) container
				.getPresentationContainer()
				.getPresentationComponent(
				PropertyManager.class);
		manager.installPropertyPanel(new LanguageSelectionPanel());
	}

	public static Class[] getDependentClasses() {
		return new Class[] { PropertyManagerPlugin.class };
	}
}
