/*
 * InstanceProfilingTableModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.profiler;

import java.util.Iterator;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.boxed_economy.besp.model.fmfw.FmFwObject;

/**
 * @author macchan
 * @version $Id: InstanceProfilingTableModel.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class InstanceProfilingTableModel extends AbstractTableModel {

	private List instanceCountersCash = null;

	/**
	 * Constructor for InstanceProfilingTableModel.
	 */
	public InstanceProfilingTableModel() {
		super();
		updateCash();
	}

	private void updateCash() {
		instanceCountersCash = FmFwObject.getInstanceCounters();
	}

	/**
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return instanceCountersCash.size();
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return 3;
	}

	/**
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		FmFwObject.InstanceCounter counter =
			(FmFwObject.InstanceCounter) instanceCountersCash.get(rowIndex);
		switch (columnIndex) {
			case 0 :
				return counter.getName();
			case 1 :
				return new Long(counter.getAlive());
			case 2 :
				return new Long(counter.getAllocated());
			default :
				return null;
		}
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	public String getColumnName(int columnIndex) {
		switch (columnIndex) {
			case 0 :
				return "Class";
			case 1 :
				return "Alive";
			case 2 :
				return "Allocated";
			default :
				return null;
		}
	}

	/**
	 * @see javax.swing.table.AbstractTableModel#fireTableDataChanged()
	 */
	public void fireTableDataChanged() {
		updateCash();
		super.fireTableDataChanged();
	}

	public String getModelString() {
		StringBuffer buf = new StringBuffer();
		Iterator i = instanceCountersCash.iterator();
		while (i.hasNext()) {
			FmFwObject.InstanceCounter counter =
				(FmFwObject.InstanceCounter) i.next();
			buf.append(ProfilerComponent.SEPARATOR);
			buf.append(counter.getName());
			buf.append(ProfilerComponent.SEPARATOR);
			buf.append(counter.getAlive());
		}
		return buf.toString();
	}

}
