/*
 * MemoryProfilingTableModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.profiler;

import java.text.NumberFormat;

import javax.swing.table.AbstractTableModel;

/**
 * @author macchan
 * @version $Id: MemoryProfilingTableModel.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class MemoryProfilingTableModel extends AbstractTableModel {

	private static final Runtime runtime = Runtime.getRuntime();
	private static final NumberFormat formatter = NumberFormat.getInstance();

	private long freeMemory = runtime.freeMemory();
	private long maxMemory = runtime.maxMemory();
	private long totalMemory = runtime.totalMemory();

	/**
	 * Constructor for InstanceProfilingTableModel.
	 */
	public MemoryProfilingTableModel() {
		super();
		updateCash();
	}

	private void updateCash() {
		freeMemory = runtime.freeMemory();
		maxMemory = runtime.maxMemory();
		totalMemory = runtime.totalMemory();
	}

	/**
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return 1;
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return 3;
	}

	/**
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		switch (columnIndex) {
			case 0 :
				return formatter.format(maxMemory);
			case 1 :
				return formatter.format(totalMemory);
			case 2 :
				return formatter.format(freeMemory);
			default :
				return null;
		}
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	public String getColumnName(int columnIndex) {
		switch (columnIndex) {
			case 0 :
				return "Max Memory";
			case 1 :
				return "Total Memory";
			case 2 :
				return "Free Memory";
			default :
				return null;
		}
	}

	/**
	 * @see javax.swing.table.AbstractTableModel#fireTableDataChanged()
	 */
	public void fireTableDataChanged() {
		updateCash();
		super.fireTableDataChanged();
	}

	public String getModelString() {
		StringBuffer buf = new StringBuffer();

		buf.append(ProfilerComponent.SEPARATOR);
		buf.append(maxMemory);
		buf.append(ProfilerComponent.SEPARATOR);
		buf.append(totalMemory);
		buf.append(ProfilerComponent.SEPARATOR);
		buf.append(freeMemory);

		return buf.toString();
	}

}
