package org.boxed_economy.components.property;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * PropertyDialog
 * BESP̊epropertyݒ肷邽߂̃_CAOł
 */
public class PropertyDialog extends JDialog {

	public static ResourceBundle resource = PropertyManagerPlugin.resource;

	private PresentationContainer presentationContainer = null;

	private List propertyPanels = new ArrayList();
	private JTabbedPane tabbedPane = new JTabbedPane();

	/**
	 * RXgN^łB
	 */
	public PropertyDialog(
		Frame owner,
		PresentationContainer presentationContainer) {
		super(owner);
		this.presentationContainer = presentationContainer;
	}

	/***********************************
	 * \鎞̏
	 ***********************************/
	public void show() {
		this.showCurrentSetting();
		while (true) {
			try {
				int res =
					JOptionPane.showConfirmDialog(
						this.getOwner(),
						this.tabbedPane,
						resource.getString("Title_PropertyDialog"),
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.PLAIN_MESSAGE);
				if (res != JOptionPane.OK_OPTION) {
					break;
				}
				this.applyNewSetting();
				break;
			}
			catch (ApplyPropertyException ex) {
				this.presentationContainer.showError(ex.getMessage(), ex);
				continue;
			}
		}
	}

	/***********************************
	 * PropertyPanel֘A
	 ***********************************/

	public void installPropertyPanel(PropertyPanel panel) {
		panel.setContainer(this.presentationContainer.getContainer());
		panel.initialize();
		this.tabbedPane.add(panel.getTitle(), panel);
		this.propertyPanels.add(panel);
	}

	private void showCurrentSetting() {
		Iterator i = this.propertyPanels.iterator();
		while (i.hasNext()) {
			PropertyPanel element = (PropertyPanel) i.next();
			element.showCurrentSetting();
		}
	}

	private void applyNewSetting() throws ApplyPropertyException {
		Iterator i = this.propertyPanels.iterator();
		while (i.hasNext()) {
			PropertyPanel element = (PropertyPanel) i.next();
			element.applyNewSetting();
		}
	}

}
