/*
 * PropertyManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.property;

import java.util.ResourceBundle;

import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.guifw.ShowDialogAction;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;

/**
 * vpeBǗNX 
 * @author macchan
 * @version $Id: PropertyManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class PropertyManager
	extends AbstractPresentationComponent
	implements SimulationStateListener {

	public static ResourceBundle resource = PropertyManagerPlugin.resource;

	/*********************************************
	 * _CAO֘A
	 *********************************************/

	private PropertyDialog propertyDialog = null;

	/*********************************************
	 * j[֘A
	 *********************************************/

	public Menu propertyMenu = new Menu();
	public ActionGroup propertyActionGroup = new ActionGroup();
	public ShowDialogAction showPropertyDialogAction = new ShowDialogAction();

	/*********************************************
	 * RXgN^
	 *********************************************/

	/**
	 * Constructor for PropertyManager.
	 */
	public PropertyManager() {
		super();
	}

	/*********************************
	 * 
	 *********************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializePropertyDialog();
		this.initializePropertyMenu();
	}

	private void initializePropertyDialog() {
		this.propertyDialog =
			new PropertyDialog(
				this.getPresentationContainer().getMainFrame(),
				this.getPresentationContainer());
	}

	private void initializePropertyMenu() {
		//j[o^
		this.getPresentationContainer().getMenuManager().propertyMenuGroup.add(
			this.propertyMenu);
		this.propertyMenu.setName(resource.getString("Menu_Property"));

		//O[v̓o^
		this.propertyMenu.add(this.propertyActionGroup);

		//vpeB_CAO̓o^
		this.showPropertyDialogAction.setDialog(this.propertyDialog);
		this.showPropertyDialogAction.setName(resource.getString("Menu_Property"));
		this.propertyActionGroup.add(this.showPropertyDialogAction);
	}

	/*********************************
	 * I
	 *********************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/*********************************
	 * pl̒ǉ
	 *********************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void installPropertyPanel(PropertyPanel panel) {
		this.propertyDialog.installPropertyPanel(panel);
	}

	/*********************************
	 * ԑJڊ֘A
	 *********************************/

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		this.propertyActionGroup.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		this.propertyActionGroup.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
	}

}
