/*
 * PropertyPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.property;

import javax.swing.JPanel;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * vpeB_CAOłŐݒł_CAOł
 * @author macchan
 * @version $Id: PropertyPanel.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public abstract class PropertyPanel extends JPanel {

	/*******************************
	 * tB[h
	 *******************************/

	private BESPContainer container = null;
	private String title = null;

	/*******************************
	 * Rei֘A
	 *******************************/

	/**
	 * Sets the container.
	 * @param container The container to set
	 */
	public void setContainer(BESPContainer container) {
		this.container = container;
	}

	/**
	 * Returns the container.
	 * @return BESPContainer
	 */
	public BESPContainer getContainer() {
		return container;
	}
		
	/*******************************
	 * O֘A
	 *******************************/	
	
	/**
	 * Returns the title.
	 * @return String
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the title.
	 * @param title The title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/*******************************
	 * ׂ\bh
	 *******************************/

	/**
	 * ܂
	 */
	public abstract void initialize();

	/**
	 * ݂̏Ԃ\܂
	 * @return \\ǂ
	 */
	public abstract void showCurrentSetting();

	/**
	 * ݒύX𔽉f܂
	 * @return f\ǂ
	 */
	public abstract void applyNewSetting() throws ApplyPropertyException;	
	
	/*******************************
	 * ֗\bhQ
	 *******************************/	

	/**
	 * Returns the ModelContainer.
	 * @return ModelContainer
	 */
	protected ModelContainer getModelContainer() {
		return this.container.getModelContainer();
	}

	/**
	 * Returns the PresentationContainer.
	 * @return PresentationContainer
	 */
	protected PresentationContainer getPresentationContainer() {
		return this.container.getPresentationContainer();
	}


}
