/*
 * AbstractRealClockLimitedTimeRunSetting.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.realclock;

import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelException;

/**
 * RealClockɂsԐݒ̒ۃNXłB
 * 
 * ̃NX̎ƂāAsԂɂݒsLimitedRunByRealTimeSetting
 * Iw肵āAݒsLimitedRunByEndRealTimeOfDaySetting
 * 
 * @author aoyama
 * @version $Id: AbstractRealClockLimitedTimeRunSetting.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public abstract class AbstractRealClockLimitedTimeRunSetting
	extends LimitedTimeRunSetting {

	/**
	*@LimitedTimeRunSettinggp錻̎vɊÂClockłB
	*  ݎƁA1step̎ԂƂ邽߂Ɏg܂B
	*/
	private RealClock clock;

	/**
	* RXgN^łBLimitedTimeRunItimeOfDayݒ肵܂B
	*/
	public AbstractRealClockLimitedTimeRunSetting(RealClock clock) {
		this.clock = clock;
	}

	/**
	 * ̐ݒɑΉClockԂ܂
	 * @return RealClock
	 */
	public RealClock getClock() {
		return clock;
	}

	/**
	 * ݒ肩sXebvvZĕԂ܂B
	 */
	public long getStep() {
		if (this.calculateStepNum() <= 0) {
			throw new ModelException(
				"calculated step is below zero (step = "
					+ this.calculateStepNum()
					+ ")");
		}
		return this.calculateStepNum();
	}

	/**
	 * Method getEndTimeOfDay.
	 * @return TimeOfDay
	 */
	public abstract TimeOfDay getEndTimeOfDay();

	/**
	  * stepNumstarttimeOfDayendTimeOfDayvZ܂B
	  * vZ̍ۂɁAtimeForStep݂͌clock̐ݒ肪g܂B
	  *
	  * ̃\bhpČvZstepNumLimitedTimeRunsȂƁA
	  * LimitedTimeRuńwendTimeOfDayȍ~timeOfDayxŎ~܂܂B
	  * ǂꂭ炢endTimeOfDayɋ߂timeOfDayɎ~܂邩́AtimeForStepׂ̍Ɉˑ܂B
	  *  @return ZoꂽstepNum
	  */
	private long calculateStepNum() {
		long stepNum;

		Time timeForStep = this.clock.getTimeForStep();
		TimeOfDay startTimeOfDay = this.clock.getCurrentTimeOfDay();

		// timeForStepsecondunit̎
		// PsecondŌvZ
		if (timeForStep.isCovertableSecond()) {
			stepNum =
				(long) Math.ceil(
					this.getEndTimeOfDay().getTimeDifference(startTimeOfDay).divide(
						timeForStep));
		}

		// timeForStepmonthunit̎
		else {
			stepNum =
				(long) Math.ceil(
					this.getEndTimeOfDay().getMonthDifference(startTimeOfDay).divide(
						timeForStep));
		}

		return stepNum;
	}

}
