package org.boxed_economy.components.realclock;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;

/**
* EndTimeOfDayLimitedTimeRunSettingPanel
*
* LimitedTimeRunlengthEndTimeOfDayŐݒ肷邽߂̃plłB
* bft[[NDefaultTimeOfDayɈˑ܂B
*/
public class EndTimeOfDayLimitedTimeRunSettingPanel
	extends LimitedTimeRunSettingPanel {

	public static ResourceBundle resource = RealClockPlugin.resource;

	private JLabel labelYear = new JLabel();
	private JTextField textFieldEndYear = new JTextField();

	private JLabel labelMonth = new JLabel();
	private JComboBox comboBoxEndMonth =
		new JComboBox(new MonthSelectComboBoxModel());

	private JLabel labelDay = new JLabel();
	private JComboBox comboBoxEndDay =
		new JComboBox(new DaySelectComboBoxModel());

	private JLabel labelUntil = new JLabel();
	private FlowLayout flowLayout = new FlowLayout();

	public EndTimeOfDayLimitedTimeRunSettingPanel() {
	}

	/**
	 * GUIR|[lg̏s܂
	 */
	public void initialize() {
		//this
		this.setPreferredSize(new Dimension(288, 35));
		this.setLayout(flowLayout);
		this.flowLayout.setAlignment(FlowLayout.LEFT);

		//until
		labelUntil.setText(resource.getString("Label_Until"));
		this.add(labelUntil, null);

		//year
		textFieldEndYear.setPreferredSize(new Dimension(40, 21));
		textFieldEndYear.setHorizontalAlignment(SwingConstants.RIGHT);
		this.add(textFieldEndYear, null);
		labelYear.setText(resource.getString("Label_Year"));
		this.add(labelYear, null);

		//month
		comboBoxEndDay.setPreferredSize(new Dimension(40, 21));
		this.add(comboBoxEndMonth, null);
		labelMonth.setText(resource.getString("Label_Month"));
		this.add(labelMonth, null);

		//day
		comboBoxEndMonth.setPreferredSize(new Dimension(40, 21));
		this.add(comboBoxEndDay, null);
		this.add(labelDay, null);
		labelDay.setText(resource.getString("Label_Day"));
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return resource.getString("Title_ByEndTimeOfDay");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		try {
			EndTimeOfDayLimitedTimeRunSetting currentSetting =
				(EndTimeOfDayLimitedTimeRunSetting) this.getLimitedTimeRunSetting();
			TimeOfDay newTimeOfDay = currentSetting.getEndTimeOfDay();

			this.textFieldEndYear.setText(String.valueOf(newTimeOfDay.getYear()));
			this.comboBoxEndMonth.setSelectedItem(
				String.valueOf(newTimeOfDay.getMonth()));
			this.comboBoxEndDay.setSelectedItem(
				String.valueOf(newTimeOfDay.getDay()));
		}
		catch (Exception ex) {
			//do nothing;
		}
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		try {
			int year = Integer.parseInt(textFieldEndYear.getText());
			int month =
				Integer.parseInt(comboBoxEndMonth.getSelectedItem().toString());
			int day = Integer.parseInt(comboBoxEndDay.getSelectedItem().toString());

			if (year <= 0) {
				throw new ApplyPropertyException("illegal year set below zero");
			}

			TimeOfDay endTimeOfDay = new TimeOfDay(year, month, day, 0, 0, 0);
			new SetStepNumByEndTimeOfDayCommand(this.getContainer(), endTimeOfDay)
				.execute();
		}
		catch (NumberFormatException ex) {
			throw new ApplyPropertyException(ex);
		}
		catch (Exception ex) {
			throw new ApplyPropertyException(ex);
		}
	}

	/**
	 * @see org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel#isCurrentTimeRunSetting()
	 */
	protected boolean isCurrentTimeRunSetting() {
		return this.getLimitedTimeRunSetting().getClass().equals(
			EndTimeOfDayLimitedTimeRunSetting.class);
	}

}