/**
 * Clock.java
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.components.realclock;

import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Clock;

/**
 * ClockԂŎ܂B
 * Ԃ̎javaGregorianCalendarNXɈˑ܂BiRealTimeOfDayQƁj
 * @author macchan
 * @version $Id: RealClock.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class RealClock extends Clock {

	public static ResourceBundle resource = RealClockPlugin.resource;

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(RealClock.class.getName());

	private static TimeOfDay DEFAULT_TIME_OF_DAY =
		new TimeOfDay(1970, 1, 1, 0, 0, 0);

	/**
	* ݂timeOfDayłB
	*/
	private TimeOfDay currentTimeOfDay;

	/**
	* XebvhourłB
	*/
	private Time timeForStep;

	/**
	* ftHgRXgN^
	* timeOfDaydefaultvalue^Đ܂B
	*/
	public RealClock() {
		this.setCurrentTimeOfDay(DEFAULT_TIME_OF_DAY);
		// 1970/1/1 0:00:00defaultɂ
		this.setTimeForStep(new Time(1, Time.hour));
		// 1hourdefaultɂ

	}

	/**
	* timeOfDaytimeForStepminutei݂܂B
	* clockEventzM܂B
	*
	* ̃\bh́AmodelThreadĂ΂邱ƂOɍĂ܂B
	* ̃IuWFNgĂ΂ꂽꍇ͕̓ۏ؂܂B
	* timeOfDay̌o߂TimeOfDayATimeݒ肳ĂȂƍsȂƂ͂ł܂B
	*/
	public synchronized void gain() {
		logger.debug(
			"Clock#EventM() \bhstart,currentTimeOfDay:"
				+ currentTimeOfDay.toString()
				+ "VXehour="
				+ System.currentTimeMillis());

		// ԊuminutetimeOfDayi߂܂
		TimeOfDay nextTimeOfDay = currentTimeOfDay.getTimeOfDay(timeForStep);
		setCurrentTimeOfDay(nextTimeOfDay);

		// clockEvent𔭐M܂B
		logger.debug(
			"Clock#EventM() \bhexit,currentTimeOfDay:"
				+ currentTimeOfDay.toString()
				+ "VXehour="
				+ System.currentTimeMillis());
	}

	/**
	* ݂timeOfDayԂ܂
	* @return currentTimeOfDay
	*/
	public TimeOfDay getCurrentTimeOfDay() {
		return currentTimeOfDay;
	}

	/**
	* ݂timeOfDayݒ肵܂B
	* modelThreadstopԂłȂꍇɁA
	* modelThreadȊOύXꂽꍇ͕̓ۏ؂܂B
	* RealTimeOfDay邢͂pNX݂̂timeOfDayƂĐݒł邱Ƃɂ܂B
	*/
	public synchronized void setCurrentTimeOfDay(TimeOfDay timeOfDay) {
		if (timeOfDay instanceof TimeOfDay) {
			currentTimeOfDay = (TimeOfDay) timeOfDay;
			logger.debug("Clock#setCurrentTimeOfDay ModelUpdateEvent𔭐M܂B");
		}
	}

	/**
	* clockEvent𔭐M邽тɐi߂hour擾܂B
	* @return timeForStep
	*/
	public Time getTimeForStep() {
		return timeForStep;
	}

	/**
	* clockEvent𔭐M邽тɐi߂hourݒ肵܂B
	*
	* modelThreadstopstatełȂꍇɁAmodelThreadȊOύXꂽꍇ͕̓ۏ؂܂B
	* RealTime邢͂pNXrunTimeƂĐݒ肷qł܂B
	* @param newtimeForStep Vݒ肷XebvrunTime
	*/
	public synchronized void setTimeForStep(Time newtimeForStep) {
		if (newtimeForStep instanceof Time) {
			logger.debug(
				"setTimeForStep RealClock" + ((Time) newtimeForStep).toString());
			if (!((Time) newtimeForStep).isPositive()) {
				throw new ModelException("Clock#setTimeForStep 0ȉ̐͐ݒł܂B");
			}

			this.timeForStep = (Time) newtimeForStep;
		}
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String separator = " : ";
		String name = resource.getString("Name_Clock");
		return name
			+ separator
			+ this.currentTimeOfDay
			+ separator
			+ "("
			+ "1step="
			+ this.timeForStep
			+ ")";
	}

}
