/*
 * RealClockPlugin.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.realclock;

import java.util.ResourceBundle;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.runsetting.CompositeLimitedTimeRunSettingPanel;
import org.boxed_economy.components.runsetting.DefaultCompositeRunSettingPanel;
import org.boxed_economy.components.runsetting.RunSettingManager;
import org.boxed_economy.components.runsetting.RunSettingManagerPlugin;
import org.boxed_economy.components.runsetting.RunSettingPanel;
import org.boxed_economy.components.stepclock.StepLimitedTimeRunSettingPanel;

/**
 * Ԃ\vpbP[WɊ܂܂AvA莞Ԏs̐ݒAyт̐ݒpGUIR|[lg
 * CXg[s܂
 * 
 * @author user
 * @version $Id: RealClockPlugin.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class RealClockPlugin implements BESPPlugin {

	public static ResourceBundle resource =
		ResourceBundle.getBundle(RealClockResource.class.getName());

	/**
	 *@Plugin񋟂ClockLimitedTimeRunSettingAyѐݒp̃pl
	 *  vOCƂăCXg[܂B
	 */
	public static void initializePlugin(BESPContainer container) {
		//pl̃CXg[
		PresentationContainer presentationContainer =
			container.getPresentationContainer();

		RunSettingManager runSettingManager =
			(RunSettingManager) presentationContainer.getPresentationComponent(
				RunSettingManager.class);
		runSettingManager.getRunSettingDialog().installRunSettingPanel(
			RealClock.class,
			createRunSettingPanel());
	}

	private static RunSettingPanel createRunSettingPanel() {
		//{pl
		DefaultCompositeRunSettingPanel panel =
			new DefaultCompositeRunSettingPanel();

		//Limitedpl
		CompositeLimitedTimeRunSettingPanel limitedPanel =
			new CompositeLimitedTimeRunSettingPanel();
		panel.add(limitedPanel);

		limitedPanel.add(new StepLimitedTimeRunSettingPanel());
		limitedPanel.add(new TimeLimitedTimeRunSettingPanel());
		limitedPanel.add(new EndTimeOfDayLimitedTimeRunSettingPanel());

		//TimeForSteppl
		panel.add(new TimeForStepRunSettingPanel());

		return panel;
	}

	/**
	 * ̃vOC̈ˑ֌WLq܂B
	 * RealClockRunSettingManagervOCɈˑĂ܂
	 */
	public static Class[] getDependentClasses() {
		return new Class[] { RunSettingManagerPlugin.class };
	}

}
