package org.boxed_economy.components.realclock;

import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * Time
 *
 * defaultŎTimeB
 * quantity\킷int^ƁAPʂ\킷String^̃tB[h܂B
 * Pʂ̕\킵java.util.Calendar̎dlɏ]܂B
 *
 * AtomicTimeUnitiŏPʎԁjƂāAsecondmonthň̂Long^̐̂߁A
 * wvZłxyear̍ől+-768614336404564650Aday̐+-106751991167300łB
 * ȏAȉ̐̎ԂƂꍇA\Ȃʂ炵܂B
 */
public class Time implements java.io.Serializable, Comparable {

	public static ResourceBundle resource = RealClockPlugin.resource;

	private static final Logger logger = Logger.getLogger(Time.class.getName());

	/**
	* second`܂B
	*/
	public static final String second = "second";

	/**
	* minute`܂B
	*/
	public static final String minute = "minute";

	/**
	* hour`܂B
	*/
	public static final String hour = "hour";

	/**
	* day`܂B
	*/
	public static final String day = "day";

	/**
	* month`܂B
	*/
	public static final String month = "month";

	/**
	* year`܂B
	*/
	public static final String year = "year";

	/**
	* Timeunit`܂B
	*/
	private String unit;

	/**
	* hourlength`܂Biۂlengthunitɏ܂Bj
	*/
	private long length; //

	/**
	*  ~secondł킵ΓIhourłB
	*/
	private long milliSecond;

	/**
	* RXgN^łBunit𕶎Ŏw肵Đ
	*/
	public Time(long newlength, String newunit) {
		checkUnit(newunit);
		length = newlength;
		unit = newunit;
	}

	/**
	* ̃IuWFNgunitA@unitgp悤Ƃexception𓊂܂B
	* @param checkUnit `FbNtargetunit
	*/
	private void checkUnit(String checkUnit) {
		logger.debug("Time#checkUnit() checkUnit=" + checkUnit);
		if (checkUnit.equals(Time.year)
			|| checkUnit.equals(Time.month)
			|| checkUnit.equals(Time.day)
			|| checkUnit.equals(Time.hour)
			|| checkUnit.equals(Time.minute)
			|| checkUnit.equals(Time.second)) {
			return;
		}
		else {
			throw new ModelException("@Timeunitgp܂B gp悤Ƃunit=" + unit);
		}
	}

	/**
	* ftHgRXgN^privateɂČĂ΂AKl^悤ɂ܂B
	*/
	private Time() {
	}

	/**
	* hour𑫂ʂԂ܂B
	* @param addTime addTime
	* @return ʂTime
	*/
	public Time add(Time addTime) {
		return addWithAtomicUnit((Time) addTime);
	}

	/**
	* hourhourhourԂ܂B
	* @param removeTime removeTime
	* @return ʂTime
	*/
	public Time remove(Time removeTime) {
		return this.addWithAtomicUnit(((Time) removeTime).reverseSign());
	}

	/**
	* vZۂɁAŏPʎԂɕϊĂvZsȂASjYłB
	* vZʂEl𒴂ꍇ́AexceptionԂ܂B
	* @param addTime addTime
	* @return ʂTime
	*/
	private Time addWithAtomicUnit(Time addTime) {

		if (!isCalculatable(addTime)) {
			throw new ModelException("݂hour͌vZ\ł͂܂");
		}

		long vlength =
			this.getTimeByAtomicUnit().getLength()
				+ addTime.getTimeByAtomicUnit().getLength();
		String vZunit = this.getTimeByAtomicUnit().getUnit();

		return new Time((int) vlength, vZunit);

	}

	/**
	* unit𒲂ׂāAvZ邱Ƃł邩Ԃ܂B
	* @param targethour isCalculatable𒲂ׂtargethour
	* @return isCalculatableǂ̐^U
	*/
	private boolean isCalculatable(Time targethour) {
		if (isCovertableSecond()) {
			return targethour.isCovertableSecond();
		}
		else {
			return !targethour.isCovertableSecond();
		}
	}

	/**
	* hourϊ\AtomicUnitTimeɂĕԂ܂B
	* yearmonthAunitmonthAdayhourminutesecondAunitsecondɂȂ܂B
	* @return AtomicTimeɕϊꂽhour
	*/
	private Time getTimeByAtomicUnit() {
		if (isCovertableSecond()) {
			return new Time((int) this.getSecondNum(), Time.second);
		}
		else {
			return new Time((int) this.getMonthNum(), Time.month);
		}
	}

	/**
	* hourunitmonth܂yearłȂ𒲂ׂāAsecondunitɕϊł邩Ԃ܂
	* @return secondɕϊł邩̐^U
	*/
	public boolean isCovertableSecond() {
		return !unit.equals(Time.year) && !unit.equals(Time.month);
	}

	/**
	* TimesecondԂ܂B
	* @retrun second
	*/
	private long getSecondNum() {
		if (unit.equals(Time.day)) {
			return length * 60L * 60L * 24L;
		}
		else if (unit.equals(Time.hour)) {
			return length * 60L * 60L;
		}
		else if (unit.equals(Time.minute)) {
			return length * 60L;
		}
		else if (unit.equals(Time.second)) {
			return length;
		}
		else {
			throw new ModelException(
				"hourunit" + unit + "łɂւ炸AsecondԂ()\bhrun܂B");
		}
	}

	/**
	* TimemonthԂ܂B
	* @return monthɕϊhour
	*/
	private long getMonthNum() {
		if (unit.equals(Time.year)) {
			return length * 12L;
		}
		else if (unit.equals(Time.month)) {
			return length;
		}
		else {
			throw new ModelException("hourunitmonthyearł͂Ȃɂւ炸AmonthԂ()\bhrun܂B");
		}
	}

	/**
	* TimereverseSign̂Ԃ܂
	* @return reverseSignTime
	*/
	private Time reverseSign() {
		return new Time(-this.getLength(), this.getUnit());
	}

	/**
	* TimeTimeŊZʂԂ܂B
	* i0Ŋ낤Ƃexception𔭂܂Bj
	* @param targethour 낤ƂTime
	* @return ʂƂĂ̊ij
	*/
	public double divide(Time targethour) throws ModelException {
		if (targethour.isZero())
			throw new ModelException("Time#divide hourOdividevZ悤Ƃ܂B");

		if (!isCalculatable((Time) targethour)) {
			throw new ModelException("݂hour͌vZ\ł͂܂");
		}

		return (double) this.getTimeByAtomicUnit().getLength()
			/ (double) ((Time) targethour).getTimeByAtomicUnit().getLength();
	}

	/**
	* Time0rł邩Ԃ܂B
	* iOdividevZƂ͂̃\bhgāAK0Ŋ邱ƂȂ悤ɂĂBj
	* @return 0ǂ̐^U
	*/
	public boolean isZero() {
		return (length == 0);
	}

	/**
	* Timeł邩Ԃ܂B
	* TiměvZsȂۂɁA̐ȂꍇÃ\bhŃ`FbNsȂ܂B
	* @return ̐ǂ̐^U
	*/
	public boolean isPositive() {
		return length > 0;
	}

	/**
	* TimelengthԂ܂
	* @return length
	*/
	public long getLength() {
		return length;
	}

	/**
	* Timelengthݒ肵܂
	* @param newLength length
	*/
	public void setLength(long newLength) {
		length = newLength;
	}

	/**
	* TimeunitԂ܂B
	* @return unit
	*/
	public String getUnit() {
		return unit;
	}

	/**
	* Timeunitݒ肵܂B
	* @param newUnit unit
	*/
	public void setUnit(String newUnit) {
		unit = newUnit;
	}

	/**
	* TimeƔrēłΐ^Ԃ܂B
	* iAtomicTimer܂Bj
	* @param target rtargetTime
	* @return ǂ̐^U
	*/
	public boolean equals(Object target) {
		if (!(target instanceof Time)) {
			return false;
		}
		if (!this.isCalculatable((Time) target)) {
			return false;
		}

		return (
			this.getTimeByAtomicUnit().getLength()
				== ((Time) target).getTimeByAtomicUnit().getLength());
	}

	/**
	* hashCodeԂ܂B
	* AtomicUnitTimeɕϊA𕶎ɂA̕hashCodenbVlƂ܂B
	* @return hour̃nbVl
	*/
	public int hashCode() {
		return this.getTimeByAtomicUnit().toString().hashCode();
	}

	/**
	* ̃IuWFNg̕\Ԃ܂B
	* u<length><unit>vŕ\܂B
	* @return \ꂽTime
	*/
	public String toString() {
		return this.getLength() + resource.getString(this.getUnit());
	}

	/**
	* Timelengthr܂B
	* Aunit݂ɊZs\ł΁Aexception𔭐܂
	* ̃IuWFNg傫1,0, Ȃ-1Ԃ܂
	* @param target rtarget
	* @return r
	*/
	public int compareTo(Object target) {
		try {
			Time targetTime = (Time) target;

			if (this.isCalculatable(targetTime)) {
				throw new ModelException("vZs\Ȃ̂r悤Ƃ܂");
			}

			long  =
				this.getTimeByAtomicUnit().getLength()
					- targetTime.getTimeByAtomicUnit().getLength();

			if ( > 0)
				return 1;
			else if ( == 0)
				return 0;
			else
				return -1;

		}
		catch (ClassCastException NXLXgexception) {
			throw new ModelException("DefaultTimeƂł͂Ȃ̂r悤Ƃ܂B");
		}
	}

}
