package org.boxed_economy.components.realclock;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.apache.log4j.Logger;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.RunSettingPanel;

/**
 * TimeForStepRunSettingPanel
 *
 * timeForStepݒ肷邽߂̃plłB
 * hourŎw肷邽߂ɁAbft[[NɈˑ܂B
 */
public class TimeForStepRunSettingPanel extends RunSettingPanel {

	public static ResourceBundle resource = RealClockPlugin.resource;

	private static final Logger logger =
		Logger.getLogger(TimeForStepRunSettingPanel.class.getName());

	private JComboBox comboBoxStepUnit =
		new JComboBox(new TimeUnitSelectComboBoxModel());
	private JLabel labelFor1Step = new JLabel();
	private JLabel labelAs = new JLabel();
	private JTextField textFieldStepNum = new JTextField();

	/**
	 * @see java.lang.Object#Object()
	 */
	public TimeForStepRunSettingPanel() {
	}

	/**
	 * GUIR|[lg̏s܂
	 */
	public void initialize() {
		FlowLayout layout = new FlowLayout();
		this.setLayout(layout);
		layout.setAlignment(FlowLayout.LEFT);
		this.setPreferredSize(new Dimension(288, 45));
		
		//LabelFor1Step
		labelFor1Step.setText(resource.getString("Label_For1Step"));
		this.add(labelFor1Step, null);
				
		//eLXgtB[h
		textFieldStepNum.setPreferredSize(new Dimension(40, 21));
		textFieldStepNum.setHorizontalAlignment(SwingConstants.RIGHT);
		this.add(textFieldStepNum, null);
		
		//ComboBox
		comboBoxStepUnit.setPreferredSize(new Dimension(80, 21));		
		this.add(comboBoxStepUnit, null);		

		//LabelStep			
		labelAs.setText(resource.getString("Label_As"));				
		this.add(labelAs, null);		
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return resource.getString("Title_TimeForStepSetting");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		RealClock clock = (RealClock) this.getClock();
		Time time = clock.getTimeForStep();
		this.textFieldStepNum.setText(String.valueOf(time.getLength()));
		this.comboBoxStepUnit.setSelectedItem(time.getUnit());
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		try {
			long num = Long.parseLong(textFieldStepNum.getText());
			if (num <= 0) {
				throw new ApplyPropertyException("illegal number set - below zero");
			}

			Time time = new Time(num, comboBoxStepUnit.getSelectedItem().toString());

			logger.debug(
				"setTimeforStep"
					+ num
					+ ":"
					+ comboBoxStepUnit.getSelectedItem().toString());

			new SetTimeForStepCommand(this.getContainer(), time).execute();
		}
		catch (NumberFormatException ex) {
			throw new ApplyPropertyException("illegal number format");
		}catch(Exception ex){
			this.getPresentationContainer().showError("Error in TimeForStepRunSetting",ex);
		}
	}

}