package org.boxed_economy.components.realclock;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;

/**
 * TimeLimitedTimeRunSettingPanel
 *
 * hourLimitedTimeRunlengthݒ肷邽߂̃plłB
 */
public class TimeLimitedTimeRunSettingPanel
	extends LimitedTimeRunSettingPanel {

	public static ResourceBundle resource = RealClockPlugin.resource;

	private JLabel labelBy = new JLabel();
	private JComboBox comboBoxTimeUnitSelect =
		new JComboBox(new TimeUnitSelectComboBoxModel());
	private JTextField textFieldTimeInput = new JTextField();

	public TimeLimitedTimeRunSettingPanel() {
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#initialize()
	 */
	public void initialize() {
		//this
		this.setPreferredSize(new Dimension(288, 35));
		FlowLayout flowLayout = new FlowLayout();
		flowLayout.setAlignment(FlowLayout.LEFT);
		this.setLayout(flowLayout);

		//label
		labelBy.setText(resource.getString("Label_By"));
		this.add(labelBy);

		//textfield
		textFieldTimeInput.setPreferredSize(new Dimension(38, 21));
		textFieldTimeInput.setHorizontalAlignment(SwingConstants.RIGHT);
		this.add(textFieldTimeInput, null);

		//comboBox
		comboBoxTimeUnitSelect.setPreferredSize(new Dimension(80, 21));
		this.add(comboBoxTimeUnitSelect, null);
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return resource.getString("Title_ByTime");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		try {
			TimeLimitedTimeRunSetting currentSetting =
				(TimeLimitedTimeRunSetting) this.getLimitedTimeRunSetting();
			Time time = currentSetting.getRunTime();
			this.textFieldTimeInput.setText(String.valueOf(time.getLength()));
			this.comboBoxTimeUnitSelect.setSelectedItem(time.getUnit());
		}
		catch (Exception ex) {
			//do nothing;
		}
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		try {
			String unit = (String) comboBoxTimeUnitSelect.getSelectedItem();
			int num = Integer.parseInt(this.textFieldTimeInput.getText());

			if (num <= 0) {
				throw new ApplyPropertyException("illegal value set - below zero.");
			}

			RealClock clock = (RealClock) this.getClock();
			TimeLimitedTimeRunSetting newSetting =
				new TimeLimitedTimeRunSetting(clock, new Time(num, unit));
			this.getModelContainer().setLimitedRunSetting(newSetting);

		}
		catch (NumberFormatException ex) {
			throw new ApplyPropertyException(ex);
		}
		catch (Exception ex) {
			throw new ApplyPropertyException(ex);
		}
	}

	/**
	 * @see org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel#isCurrentTimeRunSetting()
	 */
	protected boolean isCurrentTimeRunSetting() {
		return this.getLimitedTimeRunSetting().getClass().equals(
			TimeLimitedTimeRunSetting.class);
	}

}