package org.boxed_economy.components.realclock;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.boxed_economy.besp.model.ModelException;

/**
 * TimeOfDay
 *
 * defaulttimeOfDayGregorianCalendarŎ܂B
 * month1n܂悤ɕϊ܂B
 */
public class TimeOfDay implements java.io.Serializable {

	/**
	 * defaultvalue
	 */
	private static final TimeOfDay DEFAULT = new TimeOfDay(1970, 1, 1, 0, 0, 0);

	/**
	 * ŕێĂtimeOfDayłB
	 */
	private GregorianCalendar calendar = null;

	/**
	 * RXgN^łB
	 * yearEmonthEdayEhourEminuteEsecond^calendar𐶐܂B
	 * iGcalendarł1month0monthƂ̂ŁAcalendarłmontḧ-1܂B)
	 */
	public TimeOfDay(
		int year,
		int month,
		int day,
		int hour,
		int minute,
		int second) {
		calendar =
			new GregorianCalendar(year, month - 1, day, hour, minute, second);
	}

	/**
	 * RXgN^łBGregorianCalendarɂĐ܂B
	 */
	private TimeOfDay(GregorianCalendar calendar) {
		this.calendar = calendar;
	}

	/**
	* ̃IuWFNg\킵ĂtimeOfDayhouri߂timeOfDayԂ܂B
	* calendarGregorianCalendarňĂ邽Integer̍ővaluehouri߂邱Ƃ͂ł܂B
	* @param gainTime o߂hour
	* @return o߂timeOfDay
	*/
	public TimeOfDay getTimeOfDay(Time gainTime) {
		// i߂悤ƂhourȂǂ`FbN
		long length = ((Time) gainTime).getLength();
		if (length > Integer.MAX_VALUE) {
			throw new ModelException("houro() timeOfDayi߂悤Ƃhour܂B");
		}

		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();

		String unit = ((Time) gainTime).getUnit();
		if (unit.equals(Time.year)) {
			newCalendar.add(Calendar.YEAR, (int) length);
		}
		else if (unit.equals(Time.month)) {
			newCalendar.add(Calendar.MONTH, (int) length);
		}
		else if (unit.equals(Time.day)) {
			newCalendar.add(Calendar.DATE, (int) length);
		}
		else if (unit.equals(Time.hour)) {
			newCalendar.add(Calendar.HOUR, (int) length);
		}
		else if (unit.equals(Time.minute)) {
			newCalendar.add(Calendar.MINUTE, (int) length);
		}
		else if (unit.equals(Time.second)) {
			newCalendar.add(Calendar.SECOND, (int) length);
		}

		return new TimeOfDay(newCalendar);
	}

	/**
	* ̃J_[wĂtimeOfDayƈtimeOfDay̍TimeŕԂ܂B
	* ir͂timeOfDaysecondɕϊčsȂ܂Bj
	* @param target rtargettimeOfDay
	* @return@getTimeDifference
	*/
	public Time getTimeDifference(TimeOfDay target) {
		long getTimeDifference~second =
			calendar.getTime().getTime()
				- ((TimeOfDay) target).calendar.getTime().getTime();

		return new Time(getTimeDifference~second / 1000, Time.second);
	}

	/**
	 * DefaultTimeOfDayŕtꂽ\bh
	 * getTimeDifferencemonthunitƂĕԂ܂B
	 * monthdayunitŐ؂艺܂
	 * @param target rtimeOfDay
	 * @return ƂĂhour
	 */
	public Time getMonthDifference(TimeOfDay target) {
		long myMonth = getYear() * 12 + getMonth();
		long targetMonth = target.getYear() * 12 + target.getMonth();
		long monthNum = myMonth - targetMonth;
		return new Time(monthNum, Time.month);
	}

	/**
	* yearԂ܂B
	* @return year
	*/
	public int getYear() {
		return calendar.get(Calendar.YEAR);
	}

	/**
	* monthԂ܂B
	* @return month
	*/
	public int getMonth() {
		return calendar.get(Calendar.MONTH) + 1;
	}

	/**
	* dayԂ܂B
	* @return day
	*/
	public int getDay() {
		return calendar.get(Calendar.DATE);
	}

	/**
	* hourԂ܂B
	* @return hour
	*/
	public int getHour() {
		return calendar.get(Calendar.HOUR_OF_DAY);
	}

	/**
	* minuteԂ܂B
	* @return minute
	*/
	public int getMinute() {
		return calendar.get(Calendar.MINUTE);
	}

	/**
	* secondԂ܂B
	* @return second
	*/
	public int getSecond() {
		return calendar.get(Calendar.SECOND);
	}

	/**
	* ŕ\ꂽAyearo߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getTimeOfDayByYear(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.YEAR, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* ŕ\ꂽAmontho߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getMonthTimeOfDayByMonth(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.MONTH, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* ŕ\ꂽAdayo߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getTimeOfDayByDay(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.DATE, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* ŕ\ꂽAhouro߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getTimeOfDayByHour(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.HOUR, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* ŕ\ꂽAminuteo߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getTimeOfDayByMinute(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.MINUTE, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* ŕ\ꂽAsecondo߂timeOfDayԂ܂B
	* @return otimeOfDay
	*/
	public TimeOfDay getTimeOfDayBySecond(int addvalue) {
		GregorianCalendar newCalendar = (GregorianCalendar) calendar.clone();
		newCalendar.add(Calendar.SECOND, addvalue);
		return new TimeOfDay(newCalendar);
	}

	/**
	* timeOfDay̔rsAłΐ^Ԃ܂B
	* calendarequalss܂BiGregorianCalendarequalsimplɈˑ܂Bj
	* @param target rtarget
	* @return ǂ̐^U
	*/
	public boolean equals(Object target) {
		return calendar.equals(((TimeOfDay) target).calendar);
	}

	/**
	* nbVR[hԂ܂B
	* calendarhashCodeԂ܂BiGregorianCalendarhashCodeimplɈˑ܂Bj
	* @return nbVl
	*/
	public int hashCode() {
		return calendar.hashCode();
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂
	 * ݂₷邽߁AGregorianJ_[̂A
	 * year/month/day/hour/minute/second/mso͂܂
	 * @return timeOfDay̕\
	 */
	public String toString() {
		DateFormat df = DateFormat.getDateTimeInstance();
		return df.format(this.calendar.getTime());
	}

}
