/*
 * AbstractCompositeRunSettingPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.container.BESPContainer;

/**
 * @author macchan
 * @version $Id: AbstractCompositeRunSettingPanel.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public abstract class AbstractCompositeRunSettingPanel
	extends RunSettingPanel {

	private List runSettingPanels = new ArrayList();

	/*******************************
	 * 
	 *******************************/

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#initialize()
	 */
	public void initialize() {
		this.setLayout(new CompositeRunSettingPanelLayout());
		this.childrenInitialize();
	}

	private void childrenInitialize() {
		Iterator i = this.runSettingPanels.iterator();
		while (i.hasNext()) {
			RunSettingPanel element = (RunSettingPanel) i.next();
			element.initialize();
		}
	}

	/*******************************
	 * qRunSettingPanel֘A
	 *******************************/

	/**
	 * RunSettingPanelǉ܂
	 */
	public void add(RunSettingPanel runSettingPanel) {
		if (!this.runSettingPanels.contains(runSettingPanel)) {
			this.runSettingPanels.add(runSettingPanel);
		}
		super.add(runSettingPanel);
	}

	/**
	 * RunSettingPanel̃Xg擾܂
	 * @return List
	 */
	public List getRunSettingPanels() {
		return new ArrayList(this.runSettingPanels);
	}

	/*******************************
	 * I[o[Ch
	 *******************************/

	/**
	 * @see org.boxed_economy.components.control.RunSettingPanel#setContainer(BESPContainer)
	 */
	public void setContainer(BESPContainer container) {
		super.setContainer(container);
		Iterator i = this.runSettingPanels.iterator();
		while (i.hasNext()) {
			RunSettingPanel element = (RunSettingPanel) i.next();
			element.setContainer(container);
		}
	}

}
