/*
 * CompositeLimitedTimeRunSettingPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.ResourceBundle;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.components.property.ApplyPropertyException;

/**
 * @author macchan
 * @version $Id: CompositeLimitedTimeRunSettingPanel.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class CompositeLimitedTimeRunSettingPanel
	extends AbstractCompositeRunSettingPanel {

	public static ResourceBundle resource = RunSettingManagerPlugin.resource;

	/*************************************
	 * tB[h
	 *************************************/
	private LimitedTimeRunSettingPanel currentPanel = null;
	private ButtonGroup buttonGroup = null;

	/*************************************
	 * I[o[Ch
	 *************************************/

	/**
	 * RunSettingPanelǉ܂
	 */
	public void add(RunSettingPanel runSettingPanel) {
		if (!(runSettingPanel instanceof LimitedTimeRunSettingPanel)) {
			throw new PresentationException("cannot add because not LimitedTimeRunSettingPanel");
		}
		super.add(runSettingPanel);
	}

	/*************************************
	 * 
	 *************************************/

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return resource.getString("Title_LimitedTimeRunSetting");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		this.removeAll();
		this.buttonGroup = new ButtonGroup();
		Iterator i = this.getRunSettingPanels().iterator();
		while (i.hasNext()) {
			LimitedTimeRunSettingPanel element =
				(LimitedTimeRunSettingPanel) i.next();
			this.add(this.createPanel(element));
			element.showCurrentSetting();
		}
	}

	private JPanel createPanel(final LimitedTimeRunSettingPanel element) {
		JPanel panel = new JPanel();
		panel.setLayout(new CompositeRunSettingPanelLayout(2));
		if (element.getTitle() != null) {
			final JRadioButton button = new JRadioButton(element.getTitle());
			this.buttonGroup.add(button);
			button.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getItem() == button) {
						setCurrentPanel(element);
					}
				}
			});
			if (element.isCurrentTimeRunSetting()) {
				this.buttonGroup.setSelected(button.getModel(), true);
			}
			panel.add(button);
		}
		panel.add(element);
		return panel;
	}

	private void setCurrentPanel(LimitedTimeRunSettingPanel element) {
		Iterator i = this.getRunSettingPanels().iterator();
		while (i.hasNext()) {
			LimitedTimeRunSettingPanel panel = (LimitedTimeRunSettingPanel) i.next();
			if (panel == element) { //turn on
				panel.setEnabled(true);
				this.currentPanel = panel;
			}
			else { //turn off
				panel.setEnabled(false);
			}
		}
	}

	/**
	 * Method applyNewSetting.
	 * @throws ApplyPropertyException
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		if (currentPanel != null) {
			this.currentPanel.applyNewSetting();
		}
	}

}
