/*
 * DefaultCompositeRunSettingPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import java.awt.Label;
import java.util.Iterator;

import javax.swing.BorderFactory;

import org.boxed_economy.components.property.ApplyPropertyException;

/**
 * @author macchan
 * @version $Id: DefaultCompositeRunSettingPanel.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class DefaultCompositeRunSettingPanel
	extends AbstractCompositeRunSettingPanel {

	/**
	 * Constructor for DefaultCompositeRunSettingPanel.
	 */
	public DefaultCompositeRunSettingPanel() {
		super();
	}

	/*******************************
	 * 
	 *******************************/

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		this.removeAll();
		Iterator i = this.getRunSettingPanels().iterator();
		while (i.hasNext()) {
			RunSettingPanel element = (RunSettingPanel) i.next();
			element.showCurrentSetting();
			if (element.getTitle() != null) {
				this.add(new Label(element.getTitle()));
			}
			if (element.getBorder() == null) {
				element.setBorder(BorderFactory.createEtchedBorder());
			}
			this.add(element);
		}
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		Iterator i = this.getRunSettingPanels().iterator();
		while (i.hasNext()) {
			RunSettingPanel element = (RunSettingPanel) i.next();
			element.applyNewSetting();
		}
	}

}
