/*
 * LimitedTimeRunSettingPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import javax.swing.JTextField;

import org.boxed_economy.besp.model.LimitedTimeRunSetting;

/**
 * @author macchan
 * @version $Id: LimitedTimeRunSettingPanel.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public abstract class LimitedTimeRunSettingPanel extends RunSettingPanel {

	/*******************************
	* I[o[Ch
	*******************************/

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void setEnabled(boolean enable) {
		synchronized (this.getTreeLock()) {
			int len = this.getComponentCount();
			for (int i = 0; i < len; i++) {
				this.getComponent(i).setEnabled(enable);
				if (this.getComponent(i) instanceof JTextField) {
					((JTextField) this.getComponent(i)).setEditable(enable);
				}
			}
		}
	}

	/*******************************
	* ׂ\bh
	*******************************/

	/**
	 * Method isCurrentTimeRunSetting.
	 * @return boolean
	 */
	protected abstract boolean isCurrentTimeRunSetting();

	/*******************************
	 * ֗\bh
	 *******************************/

	/**
	 * Returns the ModelContainer.
	 * @return ModelContainer
	 */
	protected LimitedTimeRunSetting getLimitedTimeRunSetting() {
		return this.getModelContainer().getLimitedTimeRunSetting();
	}

}
