package org.boxed_economy.components.runsetting;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.property.ApplyPropertyException;

/**
 * RunSettingDialog
 *
 * LimitedTimeRun̐ݒsȂ߂̃EChEłB
 */
public class RunSettingDialog extends JDialog {

	public static ResourceBundle resource = RunSettingManagerPlugin.resource;

	private static final Logger logger =
		Logger.getLogger(RunSettingDialog.class.getName());

	/************************************
	 * tB[h
	 ************************************/

	private BESPContainer container = null;
	private RunSettingManager manager = null;

	//CXg[ꂽRunSettingDialog[Clock.class : RunSettingDialog.instance]̃}bv
	private Map panels = new HashMap();

	/************************************
	 * RXgN^
	 ************************************/

	public RunSettingDialog(RunSettingManager manager, BESPContainer container) {
		super(container.getPresentationContainer().getMainFrame());
		this.container = container;
		this.manager = manager;
	}

	/************************************
	 * RunSettingPanel֘A
	 ************************************/

	public void installRunSettingPanel(
		Class clockClass,
		RunSettingPanel runSettingPanel) {
		runSettingPanel.setContainer(this.container);
		runSettingPanel.initialize();
		this.panels.put(clockClass, runSettingPanel);
		logger.info(clockClass.getName() + " installed in RunSettingPanel");
	}

	private RunSettingPanel getRunSettingPanel() {
		Clock clock = this.getClock();
		if (this.getClock() == null) {
			return null;
		}
		RunSettingPanel panel =
			(RunSettingPanel) this.panels.get(this.getClock().getClass());
		return panel;
	}

	private Clock getClock() {
		World model = this.container.getModelContainer().getModel();
		if (model == null) {
			return null;
		}
		return model.getClock();
	}

	/************************************
	 * \֘A
	 ************************************/
	public void show() {
		RunSettingPanel panel = this.getRunSettingPanel();
		if (panel == null) {
			this.showNullDialog();
		}
		else {
			panel.showCurrentSetting();
			this.showDialog(panel);
		}
	}

	private void showDialog(RunSettingPanel panel) {
		while (true) {
			try {
				int res =
					JOptionPane.showConfirmDialog(
						this.getOwner(),
						panel,
						resource.getString("Title_RunSetting"),
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.PLAIN_MESSAGE);
				if (res != JOptionPane.OK_OPTION) {
					break;
				}
				panel.applyNewSetting();
				this.manager.getExtendPanel().refresh();
				break;
			}
			catch (ApplyPropertyException ex) {
				this.container.getPresentationContainer().showError(
					ex.getMessage(),
					ex);
				continue;
			}
		}
	}

	private void showNullDialog() {
		JOptionPane.showMessageDialog(this.getOwner(), "ΉPanelCXg[Ă܂");
	}

}