/*
 * RunSettingManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import java.util.ResourceBundle;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.guifw.ShowDialogAction;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.components.control.ControlManager;

/**
 * sݒǗReił
 * sݒgpliplj
 * sݒ_CAO̊Ǘs܂
 * @author macchan
 * @version $Id: RunSettingManager.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class RunSettingManager
	extends AbstractPresentationComponent
	implements SimulationStateListener, ModelContainerListener, UpdateClockListener {

	public static ResourceBundle resource = RunSettingManagerPlugin.resource;

	/********************************
	 * _CAO
	 ********************************/

	private RunSettingDialog runSettingDialog = null;
	private RunSettingShowExtendPanel extendPanel = null;

	/********************************
	 * j[֘A
	 ********************************/

	public ActionGroup settingGroup = new ActionGroup();
	public Action runSettingAction = null;

	/********************************
	 * RXgN^
	 ********************************/

	/**
	 * Constructor for RunSettingManager.
	 */
	public RunSettingManager() {
		super();
	}

	/********************************
	 * 
	 ********************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeRunSettingDialog();
		this.initializeMenu();
		this.initializeExtendPanel();		
		this.hookUpdateEvent();
	}

	private void initializeRunSettingDialog() {
		this.runSettingDialog =
			new RunSettingDialog(
				this,
				this.getPresentationContainer().getContainer());
	}

	private void initializeMenu() {
		//ݒO[v
		ControlManager controlManager =
			(ControlManager) this
				.getPresentationContainer()
				.getPresentationComponent(
				ControlManager.class);
		controlManager.controlMenu.add(this.settingGroup);

		//ANV
		this.runSettingAction = new ShowDialogAction(this.runSettingDialog);
		this.runSettingAction.setName(resource.getString("Menu_RunSetting"));
		this.settingGroup.add(this.runSettingAction);
	}

	private void initializeExtendPanel() {
		this.extendPanel =
			new RunSettingShowExtendPanel(
				this.getPresentationContainer().getModelContainer(),
				this.runSettingAction);
		ControlManager controlManager =
			(ControlManager) this
				.getPresentationContainer()
				.getPresentationComponent(
				ControlManager.class);
		controlManager.getControlPanel().installExtendPanel(this.extendPanel);
	}

	/***************************************
	 * I
	 ***************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
		this.unhookUpdateEvent();
	}
	
	/***************************************
	 * Cxg̎M
	 ***************************************/	
	private void hookUpdateEvent(){
		this.addUpdateClockListener(this);
	}
	
	private void unhookUpdateEvent(){
		this.removeUpdateClockListener(this);
	}

	/******************************
	 * sݒ_CAO,pl̎擾
	 ******************************/

	/**
	 * Returns the runSettingDialog.
	 * @return RunSettingDialog
	 */
	public RunSettingDialog getRunSettingDialog() {
		return this.runSettingDialog;
	}

	/**
	 * Returns the extendPanel.
	 * @return RunSettingShowExtendPanel
	 */
	public RunSettingShowExtendPanel getExtendPanel() {
		return extendPanel;
	}

	/******************************
	 * ԑJڊ֘A
	 ******************************/

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		this.runSettingAction.setEnabled(false);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		this.runSettingAction.setEnabled(true);
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.runSettingAction.setEnabled(true);
		this.extendPanel.refresh();
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
		this.settingGroup.setEnabled(false);
		this.extendPanel.refresh();
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateClockListener#clockGained(UpdateClockEvent)
	 */
	public void clockGained(UpdateClockEvent e) {
		this.extendPanel.refresh();
	}

}
