/*
 * RunSettingShowExtendPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.runsetting;

import java.awt.BorderLayout;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.presentation.bface.menu.Action;

/**
 * ݂̎sݒԂ\plŁA
 * pl̉i{^ƊJjɊgplƂĒǉ܂B
 * i usݒv{^Ă܂j
 * @author macchan
 * @version $Id: RunSettingShowExtendPanel.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class RunSettingShowExtendPanel extends JPanel {

	public static ResourceBundle resource = RunSettingManagerPlugin.resource;

	private ModelContainer modelContainer = null;
	private Action runSettingAction = null;

	private JLabel labelClock = new JLabel();
	private JLabel labelLimitedTimeRun = new JLabel();

	/**
	 * Constructor for RunSettingShowExtendPanel.
	 */
	public RunSettingShowExtendPanel(
		ModelContainer modelContainer,
		Action runSettingAction) {
		this.modelContainer = modelContainer;
		this.runSettingAction = runSettingAction;
		this.initialize();
		this.refresh();
	}

	/**
	 * 
	 */
	private void initialize() {
		this.setLayout(new BorderLayout());

		//sݒ{^Aǉ
		JButton runSettingButton = new JButton(this.runSettingAction);
		JPanel buttonPanel = new JPanel();
		this.add(buttonPanel, BorderLayout.EAST);
		buttonPanel.add(runSettingButton);

		//xǉ
		JPanel labelPanel = new JPanel();
		labelPanel.setLayout(new BorderLayout());
		labelPanel.add(this.labelClock, BorderLayout.NORTH);
		labelPanel.add(this.labelLimitedTimeRun, BorderLayout.SOUTH);
		this.add(labelPanel, BorderLayout.CENTER);
	}

	public void refresh() {
		this.showCurrentClock();
		this.showCurrentLimitedTimeRunSetting();
		this.validate();
		this.revalidate();
		this.validateTree();
	}

	/**
	 * Clock̏\܂
	 */
	protected void showCurrentClock() {
		Clock clock = this.getClock();
		if (clock != null) {
			this.labelClock.setText(clock.toString());
		}
		else {
			//this.labelClock.setText("");
		}
	}

	/**
	 * LimitedTimeRun̏\܂
	 */
	protected void showCurrentLimitedTimeRunSetting() {
		LimitedTimeRunSetting limitedTimeRunSetting =
			this.modelContainer.getLimitedTimeRunSetting();
		if (limitedTimeRunSetting != null) {
			String separator = " : ";
			this.labelLimitedTimeRun.setText(
				resource.getString("Label_LimitedTimeRunSetting")
					+ separator
					+ limitedTimeRunSetting.getDescription());
		}
		else {
			//this.labelLimitedTimeRun.setText("");
		}
	}

	/********************************
	 * ֗\bh
	 ********************************/

	private Clock getClock() {
		if (this.modelContainer.getModel() == null) {
			return null;
		}
		return this.modelContainer.getModel().getClock();
	}

}
