package org.boxed_economy.components.speedselect;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

import javax.swing.JComboBox;
import javax.swing.JLabel;

import org.boxed_economy.besp.model.ModelThread;
import org.boxed_economy.components.property.PropertyPanel;

/**
 * SpeedSelectPanel
 *
 * V~[^̑x(modelThread̑x)ݒ肷邽߂̃plłB
 * x3iKAȉ̂̂悤modelThread̊Ԋuݒ肳܂B
 * iFast=10 Normal100 Slow1000j
 */
public class SpeedSelectPanel extends PropertyPanel {

	public static ResourceBundle resource = SpeedSelectPlugin.resource;

	/*****************************
	 * tB[h
	 *****************************/
	private JComboBox comboBoxSpeedSelect =
		new JComboBox(new SpeedSelectComboBoxModel());

	/*****************************
	 * RXgN^
	 *****************************/
	public SpeedSelectPanel() {
		super();
	}

	/*****************************
	 * PropertyPanel̎
	 *****************************/

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return SpeedSelectPlugin.resource.getString("Title");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#initialize()
	 */
	public void initialize() {
		this.setPreferredSize(new Dimension(240, 120));
		FlowLayout layout = new FlowLayout();
		layout.setAlignment(FlowLayout.LEFT);
		this.setLayout(layout);

		JLabel labelSpeed = new JLabel();
		labelSpeed.setText(SpeedSelectPlugin.resource.getString("Description"));
		labelSpeed.setPreferredSize(new Dimension(240, 17));

		this.add(labelSpeed, null);
		this.add(this.comboBoxSpeedSelect, null);
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		long speed = this.getModelThread().getEventDispatchInterval();

		SpeedSelectModel[] models = SpeedSelectModel.speedModels;
		SpeedSelectModel current = models[0];
		for (int i = 0; i < models.length; i++) {
			if (models[i].speed > speed) {
				break;
			}
			current = models[i];
		}

		this.comboBoxSpeedSelect.setSelectedItem(current);
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSettting()
	 */
	public void applyNewSetting() {
		SpeedSelectModel model =
			(SpeedSelectModel) this.comboBoxSpeedSelect.getSelectedItem();
		this.getModelThread().setEventDispatchInterval(model.speed);
	}

	/*****************************
	 * ֗\bh
	 *****************************/
	public ModelThread getModelThread() {
		return this.getPresentationContainer().getModelContainer().getModelThread();
	}

}