/*
 * SpeedSelectPlugin.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.speedselect;

import java.util.ResourceBundle;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.components.property.PropertyManager;
import org.boxed_economy.components.property.PropertyManagerPlugin;

/**
 * @author macchan
 * @version $Id: SpeedSelectPlugin.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class SpeedSelectPlugin implements BESPPlugin {

	public static ResourceBundle resource =
		ResourceBundle.getBundle(SpeedSelectResource.class.getName());

	/*****************************
	 * Plugin
	 *****************************/

	public static void initializePlugin(BESPContainer container) {
		PropertyManager manager =
			(PropertyManager) container
				.getPresentationContainer()
				.getPresentationComponent(
				PropertyManager.class);
		manager.installPropertyPanel(new SpeedSelectPanel());
	}

	public static Class[] getDependentClasses() {
		return new Class[] { PropertyManagerPlugin.class };
	}

}
