package org.boxed_economy.components.stepclock;

import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;

/**
 * StepClock
 * ClockPȐɂXebvŎClockłB
 */
public class StepClock extends Clock {

	public static ResourceBundle resource = StepClockPlugin.resource;

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(StepClock.class.getName());

	private long step = 0;

	/**
	 * timeOfDayPi߂܂B
	 */
	public void gain() {
		step++;
	}

	/**
	 * Returns the step.
	 * @return long
	 */
	public long getStep() {
		return step;
	}

	/**
	 * Sets the step.
	 * @param step The step to set
	 */
	public void setStep(long step) {
		this.step = step;
		this.fireClockGained(new UpdateClockEvent(this));
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String separator = " : ";
		String name = resource.getString("Name_Clock");
		String currentStep = resource.getString("Label_CurrentStep");
		return name + separator + currentStep + this.step;
	}

}
