/*
 * StepClockPlugin
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.stepclock;

import java.util.ResourceBundle;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.runsetting.CompositeLimitedTimeRunSettingPanel;
import org.boxed_economy.components.runsetting.DefaultCompositeRunSettingPanel;
import org.boxed_economy.components.runsetting.RunSettingManager;
import org.boxed_economy.components.runsetting.RunSettingManagerPlugin;
import org.boxed_economy.components.runsetting.RunSettingPanel;

/**
 * Xebvɂ鎞ṽpbP[WɊ܂܂AvA莞Ԏs̐ݒAyт̐ݒpGUIR|[lg
 * CXg[s܂
 * 
 * @author aoyama
 * @version $Id: StepClockPlugin.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class StepClockPlugin implements BESPPlugin {

	public static ResourceBundle resource =
		ResourceBundle.getBundle(StepClockResource.class.getName());

	/**
	 *@Plugin񋟂ClockLimitedTimeRunSettingAyѐݒp̃pl
	 *  vOCƂăCXg[܂B
	 */
	public static void initializePlugin(BESPContainer container) {
		//dv!ftHgl̐ݒ
		container.getModelContainer().setLimitedRunSetting(
			new StepLimitedTimeRunSetting(1));

		//pl̃CXg[
		PresentationContainer presentationContainer =
			container.getPresentationContainer();
		RunSettingManager runSettingManager =
			(RunSettingManager) presentationContainer.getPresentationComponent(
				RunSettingManager.class);
		runSettingManager.getRunSettingDialog().installRunSettingPanel(
			StepClock.class,
			createRunSettingPanel());
	}

	private static RunSettingPanel createRunSettingPanel() {
		DefaultCompositeRunSettingPanel panel =
			new DefaultCompositeRunSettingPanel();
		CompositeLimitedTimeRunSettingPanel limitedPanel =
			new CompositeLimitedTimeRunSettingPanel();
		panel.add(limitedPanel);
		limitedPanel.add(new StepLimitedTimeRunSettingPanel());
		return panel;
	}

	/**
	 * ̃vOC̈ˑ֌WLq܂B
	 * RealClockRunSettingManagervOCɈˑĂ܂
	 */
	public static Class[] getDependentClasses() {
		return new Class[] { RunSettingManagerPlugin.class };
	}

}
