/*
 * StepLimitedTimeRunSetting.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.components.stepclock;

import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelException;

/**
 * sXebvŎꂽLimitedTimeRunNXł
 * 
 * @author rx78g
 * @version $Id: StepLimitedTimeRunSetting.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class StepLimitedTimeRunSetting extends LimitedTimeRunSetting {

	public static ResourceBundle resource = StepClockPlugin.resource;

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(StepLimitedTimeRunSetting.class.getName());

	private long step = 0;

	/**
	* RXgN^łBsXebvw肵܂B
	* @param sXebv
	*/
	public StepLimitedTimeRunSetting(long step) {
		this.setStep(step);
	}

	/**
	 * stepԂ܂B
	 * @return ݒ肳ĂXebv
	 */
	public long getStep() {
		return this.step;
	}

	/**
	 * sXebvݒ肵܂B
	 * @param step sXebv
	 */
	public void setStep(long step) {
		if (step <= 0) {
			throw new ModelException("step set below zero.");
		}
		this.step = step;
	}

	/**
	 * Xebv̐ݒ𕶎ŕԂ܂B
	 * @return 񉻂ꂽݒ
	 */
	public String getDescription() {
		String labelName = resource.getString("Label_ByStep");
		String labelStep = resource.getString("Label_Step");
		return labelName + "(" + this.step + labelStep + ")";
	}

}