package org.boxed_economy.components.stepclock;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.apache.log4j.Logger;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;

/**
 * StepLimitedTimeRunSettingPanel
 *
 * LimitedTimeRunۂstepNumŐݒ肷邽߂̃plłB
 */
public class StepLimitedTimeRunSettingPanel
	extends LimitedTimeRunSettingPanel {

	public static ResourceBundle resource = StepClockPlugin.resource;

	private static final Logger logger =
		Logger.getLogger(StepLimitedTimeRunSettingPanel.class.getName());

	private JTextField textFieldStepNum = new JTextField();
	private JLabel labelBy = new JLabel();
	private JLabel labelStep = new JLabel();
	private FlowLayout flowLayout = new FlowLayout();

	public StepLimitedTimeRunSettingPanel() {
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#initialize()
	 */
	public void initialize() {
		this.setPreferredSize(new Dimension(288, 35));
		this.setLayout(flowLayout);
		this.flowLayout.setAlignment(FlowLayout.LEFT);

		//label step
		labelBy.setText(resource.getString("Label_By"));
		this.add(labelBy, null);

		//text field
		textFieldStepNum.setPreferredSize(new Dimension(80, 21));
		textFieldStepNum.setHorizontalAlignment(SwingConstants.RIGHT);
		this.add(textFieldStepNum, null);

		//label step
		labelStep.setText(resource.getString("Label_Step"));
		this.add(labelStep, null);
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#getTitle()
	 */
	public String getTitle() {
		return resource.getString("Label_ByStep");
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#showCurrentSetting()
	 */
	public void showCurrentSetting() {
		try {
			long step = this.getLimitedTimeRunSetting().getStep();
			this.textFieldStepNum.setText(String.valueOf(step));
		}
		catch (Exception ex) {
			//do nothing;
		}
	}

	/**
	 * @see org.boxed_economy.components.property.PropertyPanel#applyNewSetting()
	 */
	public void applyNewSetting() throws ApplyPropertyException {
		try {
			long step = Long.parseLong(textFieldStepNum.getText());

			if (step <= 0) {
				throw new ApplyPropertyException("illegal value set - below zero");
			}

			StepLimitedTimeRunSetting newSetting =
				new StepLimitedTimeRunSetting(step);
			this.getModelContainer().setLimitedRunSetting(newSetting);

		}
		catch (NumberFormatException ex) {
			throw new ApplyPropertyException(ex);
		}
		catch (Exception ex) {
			throw new ApplyPropertyException(ex);
		}
	}

	/**
	 * @see org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel#isCurrentTimeRunSetting()
	 */
	protected boolean isCurrentTimeRunSetting() {
		return true;
	}

}