/*
 * InitializerTableModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.worldinitializer;

import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

import org.apache.log4j.Logger;

/**
 * NXtB[h̖OA^AftHg̒lA݂̒lARg
 * e[uŕ\߂̃fłB
 * 
 * @author aoyama
 * @version $Id: InitializerTableModel.java,v 1.2 2004/05/17 07:32:44 bam Exp $
 */
public class InitializerTableModel extends AbstractTableModel {
	private static final Logger logger =
		Logger.getLogger(InitializerTableModel.class.getName());

	private static final String COMMENT_METHOD_SURFIX = "Comment";
	public static ResourceBundle resource = WorldInitializerPlugin.resource;

	private List descriptors = null;

	private Object currentObject = null;
	private Object defaultObject = null;

	private List editableValues = null;

	private Component comp = null; //͓ẽG[ʒm邽

	/**
	 * ͂IuWFNgAIuWFNgtB[hւ̃ANZbT̃XgA
	 * G[o͂̂߂Componentw肵
	 * e[ũf𐶐܂
	 * @param world
	 * @param editableFields
	 */
	public InitializerTableModel(
		Object source,
		List discriptors,
		Component view) {
		try {
			this.currentObject = source;
			this.defaultObject = source.getClass().newInstance();

			this.descriptors = discriptors;
			this.comp = view;

			this.initializeEditedProperties();
		} catch (InstantiationException ex) {
			logger.warn("instantiation failed", ex);
		} catch (IllegalAccessException ex) {
			logger.warn("This constructor is not accessable.", ex);
		}
	}

	/**
	 * tB[h̒lGfBbg邽߂̃ZāA
	 * ݂̒lɍXV܂
	 */
	public void initializeEditedProperties() {
		editableValues = new ArrayList();

		for (int i = 0; i < descriptors.size(); i++) {
			PropertyDescriptor descriptor =
				(PropertyDescriptor) descriptors.get(i);

			editableValues.add(
				this.parseObject(descriptor, this.getCurrentValue(descriptor)));
		}
	}

	/**
	 * tB[h̒lGfBbg邽߂̃ZāA
	 * ݂̒lɍXV܂
	 */
	public void applyDefaultProperties() {
		editableValues = new ArrayList();

		for (int i = 0; i < descriptors.size(); i++) {
			PropertyDescriptor descriptor =
				(PropertyDescriptor) descriptors.get(i);

			editableValues.add(
				this.parseObject(descriptor, this.getDefaultValue(descriptor)));
		}
	}
	
	/**
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	public String getColumnName(int columnIndex) {

		switch (columnIndex) {
			case 0 :
				return resource.getString("Name");

			case 1 :
				return resource.getString("Type");

			case 2 :
				return resource.getString("Default");

			case 3 :
				return resource.getString("Current");

			case 4 :
				return resource.getString("Comment");

		}
		return null;
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return 5;
	}

	/**
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return descriptors.size();
	}

	/**
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		PropertyDescriptor descriptor =
			(PropertyDescriptor) descriptors.get(rowIndex);

		switch (columnIndex) {
			//ڂ̓vpeB̖O
			case 0 :
				return descriptor.getName();
				//ڂ͌^
			case 1 :
				return descriptor.getPropertyType();
				//Oڂ̓ftHg̒l
			case 2 :
				return this.getDefaultValue(descriptor);
				//lڂ͐Vl(ŏ̓ftHg)
			case 3 :
				return this.editableValues.get(rowIndex).toString();
				//ܗڂ̓Rg
			case 4 :
				return this.getComment(descriptor);
		}

		return null;
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnClass(int)
	 */
	public Class getColumnClass(int columnIndex) {
		return String.class;
	}

	public void update() {
		this.fireTableDataChanged();
	}

	/**
	 * @see javax.swing.table.TableModel#isCellEditable(int, int)
	 */
	public boolean isCellEditable(int row, int column) {
		logger.debug("isCellEditable:" + row + "-" + column);

		if (column == 3)
			return true;
		else
			return false;
	}

	/**
	 * @see javax.swing.table.TableModel#setValueAt(Object, int, int)
	 */
	public void setValueAt(Object value, int row, int col) {
		logger.debug("setValue:" + row + "-" + col + value.toString());

		PropertyDescriptor descriptor =
			(PropertyDescriptor) this.descriptors.get(row);
		String type = descriptor.getPropertyType().getName();
		String value_str = (String) value;

		try {
			Object value_obj = parseObject(descriptor, value_str);

			if (value_obj != null) {
				this.editableValues.set(row, value_obj);
				fireTableCellUpdated(row, col);
			} else {
				logger.warn("This type is not editable.:" + value_obj);
			}
		} catch (Exception e) {
			JOptionPane.showMessageDialog(
				comp,
				resource.getString("Invalid") + descriptor.getName());
		}
	}

	private Object parseObject(
		PropertyDescriptor descriptor,
		String value_str) {
		Object value_obj = null;

		if (descriptor.getPropertyType().getName().equals("int")) {
			value_obj = new Integer(Integer.parseInt(value_str));
		} else if (descriptor.getPropertyType().getName().equals("long")) {
			value_obj = new Long(Long.parseLong(value_str));
		} else if (
			descriptor.getPropertyType().getName().equals("char")
				&& value_str.toCharArray().length == 1) {
			value_obj = new Character(value_str.charAt(0));
		} else if (descriptor.getPropertyType().getName().equals("boolean")) {
			value_obj = Boolean.valueOf(value_str);
			logger.debug("boolean:" + value_str + "" + value_obj.toString());
		} else if (descriptor.getPropertyType().getName().equals("short")) {
			value_obj = new Short(Short.parseShort(value_str));
		} else if (descriptor.getPropertyType().getName().equals("byte")) {
			value_obj = new Byte(Byte.parseByte(value_str));
		} else if (descriptor.getPropertyType().getName().equals("double")) {
			value_obj = new Double(Double.parseDouble(value_str));
		} else if (descriptor.getPropertyType().getName().equals("float")) {
			value_obj = new Float(Float.parseFloat(value_str));
		}
		return value_obj;
	}

	private String getCurrentValue(PropertyDescriptor descriptor) {
		return getPropertyValue(currentObject, descriptor);
	}

	private String getDefaultValue(PropertyDescriptor descriptor) {
		return getPropertyValue(defaultObject, descriptor);
	}

	private String getPropertyValue(
		Object source,
		PropertyDescriptor descriptor) {
		try {
			return descriptor.getReadMethod().invoke(source, null).toString();
		} catch (IllegalAccessException e) {
			logger.warn("getter is not accessable.", e);
			return "";
		} catch (InvocationTargetException e) {
			logger.warn("getter invocation failed.", e);
			return "";
		}
	}

	private String getComment(PropertyDescriptor descriptor) {
		try {
			String commentMethodName =
				descriptor.getReadMethod().getName() + COMMENT_METHOD_SURFIX;

			Method m =
				this.currentObject.getClass().getDeclaredMethod(
					commentMethodName,
					null);
			logger.debug(commentMethodName);
			return m.invoke(currentObject, null).toString();
		} catch (NoSuchMethodException e) {
			return "";
		} catch (IllegalAccessException e) {
			return "";
		} catch (InvocationTargetException e) {
			return "";
		}
	}

	/**
	 * ݒ肳ꂽl̃XgԂ܂
	 */
	public List getNewValues() {
		return this.editableValues;
	}

}
