/*
 * WorldInitializerComponent.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.worldinitializer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.ModelThread;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.besp.presentation.guifw.CreateComponentAction;

/**
 * Elݒ肷v[e[VR|[lgł
 * ̃R|[lg͌ݐݒ肳ĂWorldpropertŷ
 * 𖞂̂ݒ肷邱Ƃł܂
 * 
 * 1,publicJava̖Kɏ]gettersetter(*)Worldɒ`Ă
 * 2,getter̕ԂlƁAsetter̈̌^ł
 * 3,getter̕ԂlƁAsetter̈̌^v~eBu^(**)ł
 * 
 * ܂property̖O"value"łƂAWorldgetValueComment()Ƃ
 * \bh`Ă΁Ã\bhԂlRgƂēǂݍނƂł܂B
 * 
 * * property̖O"value"łƂAgettergetValue()AsettersetValue()
 *   `ĂKv܂BȂAproperty̖O"l"̂悤ȓ{łƂ
 *   getl()Asetl()`ĂKv܂B
 * 
 * ** boolean,int,byte,char,long,short,double,floatw܂
 * 
 * @author aoyama
 * @version $Id: WorldInitializerComponent.java,v 1.2 2004/05/17 07:32:44 bam Exp $
 */
public class WorldInitializerComponent
	extends AbstractInternalFrameComponent
	implements BESPPlugin, SimulationStateListener, ModelContainerListener {

	private static final Logger logger =
		Logger.getLogger(WorldInitializerComponent.class.getName());

	public static ResourceBundle resource = WorldInitializerPlugin.resource;

	private boolean isChanged = false;

	private Object world = null;
	private List editableFields = null;

	private InitializerTableModel tableModel = null;

	private JTable table = new JTable();
	private JButton button_initialize =
		new JButton(resource.getString("Init_Button"));
	private JButton button_default =
		new JButton(resource.getString("Default_Button"));

	public static void initializePlugin(BESPContainer container) {
		CreateComponentAction createAction =
			new CreateComponentAction(
				resource.getString("Name_Component"),
				WorldInitializerComponent.class);
		container.getPresentationContainer().addMenuElementToToolsMenu(
			createAction);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#button_initialize()
	 */
	public void initialize() {
		this.initializeComponents();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		logger.debug("OpenWorld");

		initializeTargetModel();
		initializeTable();

		this.revalidate();
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
	}

	/**
	 * GUIR|[lg܂
	 */
	private void initializeComponents() {
		this.setSize(800, 250);
		this.setTitle(resource.getString("Name_Component"));
		JPanel tableButtonPanel = new JPanel();
		this.getContentPane().add(tableButtonPanel, BorderLayout.NORTH);

		tableButtonPanel.add(this.button_default, BorderLayout.EAST);
		button_default.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				defaultPressed();
			}
		});

		JScrollPane scroll =
			new JScrollPane(
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		this.getContentPane().add(scroll, BorderLayout.CENTER);
		scroll.getViewport().add(table);

		JPanel buttonPanel = new JPanel();

		button_initialize.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				initializePressed();
			}
		});

		this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
		buttonPanel.add(button_initialize, null);

		updateButtons();
		this.show();
	}

	/**
	 * lݒ肷ΏۂWorld͂܂
	 */
	private void initializeTargetModel() {
		try {
			logger.debug("InitializeModel");

			this.world =
				this.getPresentationContainer().getModelContainer().getModel();
			this.editableFields = new ArrayList();

			if (world == null) {
				JOptionPane.showMessageDialog(
					this,
					resource.getString("No_World_Error"));
			} else {

				BeanInfo info = Introspector.getBeanInfo(this.world.getClass());
				PropertyDescriptor[] descriptors =
					info.getPropertyDescriptors();

				for (int i = 0; i < descriptors.length; i++) {

					logger.debug(descriptors[i].getName());

					if (this.isEditableDiscriptor(descriptors[i])) {
						logger.debug("editable>" + descriptors[i].getName());
						this.editableFields.add(descriptors[i]);
					}
				}

				if (this.editableFields.size() == 0) {
					JOptionPane.showMessageDialog(
						this,
						resource.getString("No_Field_Error"));
				}
			}
		} catch (IntrospectionException e) {
			logger.warn("getting BeanInfo failed", e);
		}
	}

	/**
	 * fe[u܂B
	 */
	private void initializeTable() {
		table.removeAll();

		table.createDefaultColumnsFromModel();
		table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);

		tableModel = new InitializerTableModel(world, editableFields, this);
		tableModel.addTableModelListener(new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
				propertyChanged();
			}
		});
		table.setModel(tableModel);
	}

	/**
	 * Method updateButtons.
	 */
	private void updateButtons() {
		int state =
			getPresentationContainer()
				.getModelContainer()
				.getModelThread()
				.getState();
		updateButtons(state);
	}

	/**
	 * Method updateButtons.
	 */
	private void updateButtons(int state) {

		if (!isChanged) {
			button_initialize.setEnabled(false);
			button_default.setEnabled(false);
		} else if (state == ModelThread.RUNNING) {
			button_initialize.setEnabled(false);
			button_default.setEnabled(true);
		} else {
			button_initialize.setEnabled(true);
			button_default.setEnabled(true);
		}
	}

	private boolean isEditableDiscriptor(PropertyDescriptor descriptor) {

		if (descriptor.getReadMethod() != null
			&& descriptor.getWriteMethod() != null
			&& Modifier.isPublic(descriptor.getReadMethod().getModifiers())
			&& Modifier.isPublic(descriptor.getWriteMethod().getModifiers())
			&& descriptor.getWriteMethod().getParameterTypes().length == 1
			&& descriptor.getPropertyType()
				== descriptor.getWriteMethod().getParameterTypes()[0]
			&& descriptor.getPropertyType().isPrimitive()) {
			return true;
		}
		return false;

	}

	/**********************
	 * Cxg֌W
	 ***********************/
	private void defaultPressed() {
		int result =
			JOptionPane.showInternalConfirmDialog(
				this,
				resource.getString("Cancel_Dialog"),
				resource.getString("Confirm_Cancel"),
				JOptionPane.YES_NO_OPTION);
		if (result == JOptionPane.YES_OPTION) {
			this.tableModel.applyDefaultProperties();
			this.button_default.setEnabled(false);
		}
	}

	private void initializePressed() {
		try {
			World newWorld = (World) world.getClass().newInstance();
			List values = this.tableModel.getNewValues();

			assert(
				this.editableFields.size()
					== values.size()) : resource.getString(
				"Assert_mes");

			int result =
				JOptionPane.showInternalConfirmDialog(
					this,
					resource.getString("Init_Dialog"),
					resource.getString("Confirm_Init"),
					JOptionPane.YES_NO_OPTION);

			if (result == JOptionPane.YES_OPTION) {
				for (int i = 0; i < values.size(); i++) {
					PropertyDescriptor p =
						((PropertyDescriptor) this.editableFields.get(i));
					logger.info(
						p.getName()
							+ ":"
							+ p.getWriteMethod().getName()
							+ ":"
							+ values.get(i).getClass().getName()
							+ ":"
							+ values.get(i).toString());

					((PropertyDescriptor) this.editableFields.get(i))
						.getWriteMethod()
						.invoke(
						newWorld,
						new Object[] { values.get(i)});
				}

				this.getPresentationContainer().getModelContainer().setModel(
					newWorld);

				this.isChanged = false;
				this.button_default.setEnabled(false);
				this.button_initialize.setEnabled(false);
			}
		} catch (InstantiationException e) {
			String mes = resource.getString("Instantiation_Error");
			logger.warn(mes, e);
			this.getPresentationContainer().showError(mes, e);
		} catch (IllegalAccessException ex) {
			logger.warn("getter is not accessable.", ex);
		} catch (InvocationTargetException ex) {
			logger.warn("getter invokation failed", ex);
		}
	}

	private void propertyChanged() {
		this.isChanged = true;

		updateButtons();
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
		logger.debug("thread RUNNING");
		this.updateButtons(
			this
				.getPresentationContainer()
				.getModelContainer()
				.getModelThread()
				.getState());
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		logger.debug("thread stop");
		this.updateButtons(
			this
				.getPresentationContainer()
				.getModelContainer()
				.getModelThread()
				.getState());
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
		this.updateButtons(
			this
				.getPresentationContainer()
				.getModelContainer()
				.getModelThread()
				.getState());
	}

}
