/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.information.ContestInformation;
import org.boxed_economy.ipd.model.information.DecisionHistoryInformation;
import org.boxed_economy.ipd.model.information.MatchPairTableInformation;

public class IPDWorld
extends World {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private int turnNumber = 200;
    private int numberOfALLC = 2;
    private int numberOfALLD = 2;
    private int numberOfRANDOM = 2;
    private int numberOfTFT = 2;
    private int numberOfTF2T = 2;
    private int numberOfJOSS = 2;
    private int numberOfFRIEDMAN = 2;
    private int numberOfPERCD = 2;
    private int numberOfPERCCD = 2;
    private List referees = new ArrayList();
    private List aLLCPlayers = new ArrayList();
    private List aLLDPlayers = new ArrayList();
    private List rANDOMPlayers = new ArrayList();
    private List tFTPlayers = new ArrayList();
    private List tF2TPlayers = new ArrayList();
    private List fRIEDMANPlayers = new ArrayList();
    private List jOSSPlayers = new ArrayList();
    private List pERCDPlayers = new ArrayList();
    private List pERCCDPlayers = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.ipd.model.IPDWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.ipd.model.IPDWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public static void main(String[] args) {
        String[] stringArray = new String[4];
        stringArray[0] = "-model";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.ipd.model.IPDWorld");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = "-logbyfile";
        stringArray[3] = "log4j.ipd.properties";
        BESP.main((String[])stringArray);
    }

    public void initializeWorld() {
        logger.info((Object)"Initialize World.");
        super.initializeWorld();
        this.setClock((Clock)new StepClock());
    }

    public void initializeAgents() {
        logger.info((Object)" Initialize Agents.");
        super.initializeAgents();
        this.createAgents();
        this.addRelations();
        this.initializeByHands();
    }

    private void initializeByHands() {
        Agent referee = (Agent)this.referees.get(0);
        referee.putInformation((Information)IPDModel.INFORMATIONTYPE_MatchPairTableInformation, (Information)new MatchPairTableInformation(this.getAgents(IPDModel.AGENTTYPE_PlayerAgent)));
        Collection allPlayers = this.getAgents(IPDModel.AGENTTYPE_PlayerAgent);
        int count = 0;
        Iterator i = allPlayers.iterator();
        while (i.hasNext()) {
            Agent player = (Agent)i.next();
            player.putInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation, (Information)new MessageInformation("Player" + ++count));
        }
        LinkedList list = new LinkedList();
    }

    private void createAgents() {
        logger.info((Object)"Create Agents.");
        this.createRefereeAgent();
        this.createALLCPlayerAgents();
        this.createALLDPlayerAgents();
        this.createRANDOMPlayerAgents();
        this.createTFTPlayerAgents();
        this.createTF2TPlayerAgents();
        this.createFRIEDMANPlayerAgents();
        this.createJOSSPlayerAgents();
        this.createPERCDPlayerAgents();
        this.createPERCCDPlayerAgents();
    }

    private void addRelations() {
        logger.info((Object)"Add Relations");
        this.addSelfRelationRelations();
        this.addPlayerRelationRelations();
        this.addReferee1Relations();
    }

    private void createALLCPlayerAgents() {
        logger.info((Object)"Create ALLCPlayer Agents");
        int i = 0;
        while (i < this.numberOfALLC) {
            this.createALLCPlayerAgent();
            ++i;
        }
    }

    private void createALLDPlayerAgents() {
        logger.info((Object)"Create ALLDPlayer Agents");
        int i = 0;
        while (i < this.numberOfALLD) {
            this.createALLDPlayerAgent();
            ++i;
        }
    }

    private void createRANDOMPlayerAgents() {
        logger.info((Object)"Create RANDOMPlayer Agents");
        int i = 0;
        while (i < this.numberOfRANDOM) {
            this.createRANDOMPlayerAgent();
            ++i;
        }
    }

    private void createTFTPlayerAgents() {
        logger.info((Object)"Create TFTPlayer Agents");
        int i = 0;
        while (i < this.numberOfTFT) {
            this.createTFTPlayerAgent();
            ++i;
        }
    }

    private void createTF2TPlayerAgents() {
        logger.info((Object)"Create TF2TPlayer Agents");
        int i = 0;
        while (i < this.numberOfTF2T) {
            this.createTF2TPlayerAgent();
            ++i;
        }
    }

    private void createFRIEDMANPlayerAgents() {
        logger.info((Object)"Create FRIEDMANPlayer Agents");
        int i = 0;
        while (i < this.numberOfFRIEDMAN) {
            this.createFRIEDMANPlayerAgent();
            ++i;
        }
    }

    private void createJOSSPlayerAgents() {
        logger.info((Object)"Create JOSSPlayer Agents");
        int i = 0;
        while (i < this.numberOfJOSS) {
            this.createJOSSPlayerAgent();
            ++i;
        }
    }

    private void createPERCDPlayerAgents() {
        logger.info((Object)"Create PERCDPlayer Agents");
        int i = 0;
        while (i < this.numberOfPERCD) {
            this.createPERCDPlayerAgent();
            ++i;
        }
    }

    private void createPERCCDPlayerAgents() {
        logger.info((Object)"Create PERCCDPlayer Agents");
        int i = 0;
        while (i < this.numberOfPERCCD) {
            this.createPERCCDPlayerAgent();
            ++i;
        }
    }

    private void createRefereeAgent() {
        logger.info((Object)"Create Referee Agent");
        Agent agentReferee = super.createAgent(IPDModel.AGENTTYPE_RefereeAgent);
        agentReferee.addBehavior(IPDModel.BEHAVIORTYPE_ConductMatchBehavior);
        agentReferee.addBehavior(IPDModel.BEHAVIORTYPE_ManageContestBehavior);
        agentReferee.putInformation((Information)IPDModel.INFORMATIONTYPE_ContestCountInformation, (Information)this.createContestCountInformationForAgentReferee(agentReferee));
        agentReferee.putInformation((Information)IPDModel.INFORMATIONTYPE_CurrentContestInformation, (Information)new ContestInformation());
        this.referees.add(agentReferee);
    }

    private void createALLCPlayerAgent() {
        logger.info((Object)"Create ALLCPlayer Agent");
        Agent agentALLCPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ALLCStrategyBehavior);
        agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentALLCPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentALLCPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        agentALLCPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentALLCPlayer(agentALLCPlayer));
        this.aLLCPlayers.add(agentALLCPlayer);
    }

    private void createALLDPlayerAgent() {
        logger.info((Object)"Create ALLDPlayer Agent");
        Agent agentALLDPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ALLDStrategyBehavior);
        agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentALLDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentALLDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        agentALLDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentALLDPlayer(agentALLDPlayer));
        this.aLLDPlayers.add(agentALLDPlayer);
    }

    private void createRANDOMPlayerAgent() {
        logger.info((Object)"Create RANDOMPlayer Agent");
        Agent agentRANDOMPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentRANDOMPlayer.addBehavior(IPDModel.BEHAVIORTYPE_RANDOMStrategyBehavior);
        agentRANDOMPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentRANDOMPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentRANDOMPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentRANDOMPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        agentRANDOMPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentRANDOMPlayer(agentRANDOMPlayer));
        this.rANDOMPlayers.add(agentRANDOMPlayer);
    }

    private void createTFTPlayerAgent() {
        logger.info((Object)"Create TFTPlayer Agent");
        Agent agentTFTPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentTFTPlayer.addBehavior(IPDModel.BEHAVIORTYPE_TFTStrategyBehavior);
        agentTFTPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentTFTPlayer(agentTFTPlayer));
        agentTFTPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        this.tFTPlayers.add(agentTFTPlayer);
    }

    private void createTF2TPlayerAgent() {
        logger.info((Object)"Create TF2TPlayer Agent");
        Agent agentTF2TPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentTF2TPlayer.addBehavior(IPDModel.BEHAVIORTYPE_TF2TStrategyBehavior);
        agentTF2TPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        agentTF2TPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentTF2TPlayer(agentTF2TPlayer));
        this.tF2TPlayers.add(agentTF2TPlayer);
    }

    private void createFRIEDMANPlayerAgent() {
        logger.info((Object)"Create FRIEDMANPlayer Agent");
        Agent agentFRIEDMANPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentFRIEDMANPlayer.addBehavior(IPDModel.BEHAVIORTYPE_FRIEDMANStrategyBehavior);
        agentFRIEDMANPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentFRIEDMANPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentFRIEDMANPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentFRIEDMANPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentFRIEDMANPlayer(agentFRIEDMANPlayer));
        agentFRIEDMANPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        this.fRIEDMANPlayers.add(agentFRIEDMANPlayer);
    }

    private void createJOSSPlayerAgent() {
        logger.info((Object)"Create JOSSPlayer Agent");
        Agent agentJOSSPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentJOSSPlayer.addBehavior(IPDModel.BEHAVIORTYPE_JOSSStrategyBehavior);
        agentJOSSPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentJOSSPlayer(agentJOSSPlayer));
        agentJOSSPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        this.jOSSPlayers.add(agentJOSSPlayer);
    }

    private void createPERCDPlayerAgent() {
        logger.info((Object)"Create PERCDPlayer Agent");
        Agent agentPERCDPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentPERCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PERCDStrategyBehavior);
        agentPERCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentPERCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentPERCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentPERCDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentPERCDPlayer(agentPERCDPlayer));
        agentPERCDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        this.pERCDPlayers.add(agentPERCDPlayer);
    }

    private void createPERCCDPlayerAgent() {
        logger.info((Object)"Create PERCCDPlayer Agent");
        Agent agentPERCCDPlayer = super.createAgent(IPDModel.AGENTTYPE_PlayerAgent);
        agentPERCCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PERCCDStrategyBehavior);
        agentPERCCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ReceiveResultBehavior);
        agentPERCCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_PlayerBehavior);
        agentPERCCDPlayer.addBehavior(IPDModel.BEHAVIORTYPE_ChangeStrategyWithStrongerPlayersBehavior);
        agentPERCCDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_DecisionHistoryInformation, (Information)new DecisionHistoryInformation());
        agentPERCCDPlayer.putInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation, (Information)this.createScoreInformationForAgentPERCCDPlayer(agentPERCCDPlayer));
        this.pERCCDPlayers.add(agentPERCCDPlayer);
    }

    private void addSelfRelationRelations() {
        logger.info((Object)"add SelfRelation relations");
        ArrayList sourceAgents = new ArrayList(this.pERCCDPlayers);
        sourceAgents.addAll(this.tFTPlayers);
        sourceAgents.addAll(this.tF2TPlayers);
        sourceAgents.addAll(this.jOSSPlayers);
        sourceAgents.addAll(this.aLLCPlayers);
        sourceAgents.addAll(this.referees);
        sourceAgents.addAll(this.rANDOMPlayers);
        sourceAgents.addAll(this.pERCDPlayers);
        sourceAgents.addAll(this.aLLDPlayers);
        sourceAgents.addAll(this.fRIEDMANPlayers);
        int i = 0;
        while (i < sourceAgents.size()) {
            Agent sourceAgent = (Agent)sourceAgents.get(i);
            sourceAgent.addRelation(IPDModel.RELATIONTYPE_SelfRelation, sourceAgent);
            ++i;
        }
    }

    private void addPlayerRelationRelations() {
        logger.info((Object)"add PlayerRelation relations");
        ArrayList sourceAgents = new ArrayList(this.referees);
        ArrayList targetAgents = new ArrayList(this.pERCCDPlayers);
        targetAgents.addAll(this.tFTPlayers);
        targetAgents.addAll(this.tF2TPlayers);
        targetAgents.addAll(this.jOSSPlayers);
        targetAgents.addAll(this.aLLCPlayers);
        targetAgents.addAll(this.rANDOMPlayers);
        targetAgents.addAll(this.pERCDPlayers);
        targetAgents.addAll(this.aLLDPlayers);
        targetAgents.addAll(this.fRIEDMANPlayers);
        Agent sourceAgent = (Agent)sourceAgents.get(0);
        int i = 0;
        while (i < targetAgents.size()) {
            Agent targetAgent = (Agent)targetAgents.get(i);
            if (sourceAgent != targetAgent) {
                sourceAgent.addRelation(IPDModel.RELATIONTYPE_PlayerRelation, targetAgent);
            }
            ++i;
        }
    }

    private void addReferee1Relations() {
        logger.info((Object)"add Referee1 relations");
        ArrayList sourceAgents = new ArrayList(this.pERCCDPlayers);
        sourceAgents.addAll(this.tFTPlayers);
        sourceAgents.addAll(this.tF2TPlayers);
        sourceAgents.addAll(this.jOSSPlayers);
        sourceAgents.addAll(this.aLLCPlayers);
        sourceAgents.addAll(this.rANDOMPlayers);
        sourceAgents.addAll(this.pERCDPlayers);
        sourceAgents.addAll(this.aLLDPlayers);
        sourceAgents.addAll(this.fRIEDMANPlayers);
        ArrayList targetAgents = new ArrayList(this.referees);
        Agent targetAgent = (Agent)targetAgents.get(0);
        int i = 0;
        while (i < sourceAgents.size()) {
            Agent sourceAgent = (Agent)sourceAgents.get(i);
            if (sourceAgent != targetAgent) {
                sourceAgent.addRelation(IPDModel.RELATIONTYPE_RefereeRelation, targetAgent);
            }
            ++i;
        }
    }

    public String getName() {
        return "IPDWorld";
    }

    public String getDescription() {
        return "\u7e70\u308a\u8fd4\u3057\u56da\u4eba\u306e\u30b8\u30ec\u30f3\u30de\u306e\u30e2\u30c7\u30eb\u3067\u3059";
    }

    private IntegerInformation createScoreInformationForAgentPERCDPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentFRIEDMANPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentTF2TPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentALLCPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createContestCountInformationForAgentReferee(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentPERCCDPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentALLDPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentJOSSPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentTFTPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private IntegerInformation createScoreInformationForAgentRANDOMPlayer(Agent agent) {
        return new IntegerInformation(0);
    }

    private double generateRandomNumberByDouble(String generatorName, double max, double minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        double result = minimum + randomNumber * (max - minimum);
        return result;
    }

    private int generateRandomNumberByInt(String generatorName, int max, int minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        int result = (int)((double)minimum + randomNumber * (double)(max - minimum));
        return result;
    }

    private long generateRandomNumberByLong(String generatorName, long max, long minimum) {
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        double randomNumber = generator.generate();
        long result = (long)((double)minimum + randomNumber * (double)(max - minimum));
        return result;
    }

    private int[] generateElectedRandomNumbers(String generatorName, int number, int max, int excludedNumber) {
        if (!$assertionsDisabled && number >= max) {
            throw new AssertionError();
        }
        RandomNumberGenerator generator = super.getRandomNumberGenerator(generatorName);
        int[] electedNumbers = new int[number];
        Arrays.fill(electedNumbers, -1);
        int i = 0;
        while (i < number) {
            int generatedNumber;
            if (excludedNumber >= 0) {
                generatedNumber = generator.generate(max - 1);
                if (generatedNumber >= excludedNumber) {
                    ++generatedNumber;
                }
            } else {
                generatedNumber = generator.generate(max);
            }
            if (this.isElectedNumber(electedNumbers, generatedNumber)) {
                --i;
            } else {
                electedNumbers[i] = generatedNumber;
            }
            ++i;
        }
        return electedNumbers;
    }

    private boolean isElectedNumber(int[] electedNumbers, int target) {
        int[] copy = new int[electedNumbers.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = electedNumbers[i];
            ++i;
        }
        Arrays.sort(copy);
        int result = Arrays.binarySearch(copy, target);
        return result >= 0;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public void setTurnNumber(int turnNumber) {
        this.turnNumber = turnNumber;
    }

    public String getTurnNumberComment() {
        return "1\u56de\u306e\u5bfe\u6226\u3067\u306e\u30b2\u30fc\u30e0\u56de\u6570";
    }

    public int getNumberOfALLC() {
        return this.numberOfALLC;
    }

    public void setNumberOfALLC(int numberOfALLC) {
        this.numberOfALLC = numberOfALLC;
    }

    public String getNumberOfALLCComment() {
        return "ALLC\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfALLD() {
        return this.numberOfALLD;
    }

    public void setNumberOfALLD(int numberOfALLD) {
        this.numberOfALLD = numberOfALLD;
    }

    public String getNumberOfALLDComment() {
        return "ALLD\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfRANDOM() {
        return this.numberOfRANDOM;
    }

    public void setNumberOfRANDOM(int numberOfRANDOM) {
        this.numberOfRANDOM = numberOfRANDOM;
    }

    public String getNumberOfRANDOMComment() {
        return "RANDOM\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfTFT() {
        return this.numberOfTFT;
    }

    public void setNumberOfTFT(int numberOfTFT) {
        this.numberOfTFT = numberOfTFT;
    }

    public String getNumberOfTFTComment() {
        return "TFT\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfTF2T() {
        return this.numberOfTF2T;
    }

    public void setNumberOfTF2T(int numberOfTF2T) {
        this.numberOfTF2T = numberOfTF2T;
    }

    public String getNumberOfTF2TComment() {
        return "TF2T\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfJOSS() {
        return this.numberOfJOSS;
    }

    public void setNumberOfJOSS(int numberOfJOSS) {
        this.numberOfJOSS = numberOfJOSS;
    }

    public String getNumberOfJOSSComment() {
        return "JOSS\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfFRIEDMAN() {
        return this.numberOfFRIEDMAN;
    }

    public void setNumberOfFRIEDMAN(int numberOfFRIEDMAN) {
        this.numberOfFRIEDMAN = numberOfFRIEDMAN;
    }

    public String getNumberOfFRIEDMANComment() {
        return "FRIEDMAN\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfPERCD() {
        return this.numberOfPERCD;
    }

    public void setNumberOfPERCD(int numberOfPERCD) {
        this.numberOfPERCD = numberOfPERCD;
    }

    public String getNumberOfPERCDComment() {
        return "PERCD\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }

    public int getNumberOfPERCCD() {
        return this.numberOfPERCCD;
    }

    public void setNumberOfPERCCD(int numberOfPERCCD) {
        this.numberOfPERCCD = numberOfPERCCD;
    }

    public String getNumberOfPERCCDComment() {
        return "PERCCD\u306e\u6226\u7565\u3092\u6301\u3064\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u6570";
    }
}

