/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.model.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.behavior.AbstractConductMatchBehavior;
import org.boxed_economy.ipd.model.information.DecisionInformation;
import org.boxed_economy.ipd.model.information.MatchInformation;

public class ConductMatchBehavior
extends AbstractConductMatchBehavior {
    private static final Logger logger;
    StringBuffer firstPlayerDecisions = new StringBuffer();
    StringBuffer lastPlayerDecisions = new StringBuffer();
    StringBuffer firstPlayerScores = new StringBuffer();
    StringBuffer lastPlayerScores = new StringBuffer();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.ipd.model.behavior.ConductMatchBehavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void initializeRemainingTurnAction() {
        this.getAgent().putInformation((Information)IPDModel.INFORMATIONTYPE_RemainingTurnInformation, (Information)new IntegerInformation(this.getTurnNumber()));
    }

    protected void registerDecisionAction() {
        MatchInformation currentMatchInformation = this.getCurrentMatchInformation();
        DecisionInformation decision = (DecisionInformation)this.getReceivedInformation();
        currentMatchInformation.memoryDecision(decision.getAgent(), decision);
    }

    protected void askFirstDecisionAction() {
        this.startMatchLog();
        this.sendInformation(IPDModel.RELATIONTYPE_EntryRelation, IPDModel.BEHAVIORTYPE_PlayerBehavior, IPDModel.INFORMATIONTYPE_StartSignalInformation, (Information)new MessageInformation("Tell Me First Decision!"), false);
    }

    protected void askNextDecisionAction() {
        this.sendInformation(IPDModel.RELATIONTYPE_EntryRelation, IPDModel.BEHAVIORTYPE_PlayerBehavior, IPDModel.INFORMATIONTYPE_AskDecisionInformation, (Information)new MessageInformation("Tell Me Next Hand!"), false);
    }

    protected void reportOpponentDeceisionAction() {
        MatchInformation currentMatchInformation = this.getCurrentMatchInformation();
        Collection entries = this.getAgent().getRelations(IPDModel.RELATIONTYPE_EntryRelation);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Relation entry = (Relation)i.next();
            Agent player = entry.getTarget();
            Agent opponent = currentMatchInformation.getEntryPair().getOpponent(player);
            DecisionInformation opponentDecision = currentMatchInformation.getRecentDecision(opponent);
            this.sendInformation(entry, IPDModel.BEHAVIORTYPE_PlayerBehavior, (Information)opponentDecision);
        }
    }

    protected void reportMatchResultAction() {
        this.matchLog();
        this.sendInformation(IPDModel.RELATIONTYPE_EntryRelation, IPDModel.BEHAVIORTYPE_ReceiveResultBehavior, IPDModel.INFORMATIONTYPE_MatchResultInformation, (Information)this.getCurrentMatchInformation(), false);
        this.sendInformation(IPDModel.RELATIONTYPE_SelfRelation, IPDModel.BEHAVIORTYPE_ManageContestBehavior, IPDModel.INFORMATIONTYPE_MatchResultInformation, (Information)this.getCurrentMatchInformation(), false);
    }

    protected void prepareNextTurnAction() {
        IntegerInformation currentTurn = (IntegerInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_RemainingTurnInformation);
        this.getAgent().putInformation((Information)IPDModel.INFORMATIONTYPE_RemainingTurnInformation, (Information)new IntegerInformation(currentTurn.getValue() - 1));
        this.turnLog();
    }

    protected boolean isStartSignal(Event e) {
        return this.receivedInformationEquals(IPDModel.INFORMATIONTYPE_StartSignalInformation);
    }

    protected boolean areAllRepliesReceived(Event e) {
        MatchInformation matchInformation = this.getCurrentMatchInformation();
        return matchInformation.hasTurnFinished();
    }

    protected boolean areNotAllRepliesReceived(Event e) {
        return !this.areAllRepliesReceived(e);
    }

    protected boolean isFinalTurn(Event e) {
        return ((IntegerInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_RemainingTurnInformation)).getValue() == 0;
    }

    protected boolean isNotFinalTurn(Event e) {
        return !this.isFinalTurn(e);
    }

    private int getTurnNumber() {
        World world = this.getWorld();
        try {
            return Integer.parseInt(world.getClass().getMethod("getTurnNumber", new Class[0]).invoke((Object)world, new Object[0]).toString());
        }
        catch (Exception e) {
            logger.warn((Object)e);
            throw new ModelException("getTurnNumber failed", (Throwable)e);
        }
    }

    private MatchInformation getCurrentMatchInformation() {
        return (MatchInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_CurrentMatchInformation);
    }

    private void matchLog() {
        MatchInformation currentMatchInformation = this.getCurrentMatchInformation();
        Agent firstPlayer = currentMatchInformation.getEntryPair().getFirstPlayer();
        Agent lastPlayer = currentMatchInformation.getEntryPair().getLastPlayer();
        String playerA = firstPlayer.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
        String playerB = lastPlayer.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
        logger.info((Object)(String.valueOf(this.getStyledText(String.valueOf(playerA) + "Decision:")) + this.firstPlayerDecisions.toString()));
        logger.info((Object)(String.valueOf(this.getStyledText(String.valueOf(playerA) + "Score:")) + this.firstPlayerScores.toString()));
        logger.info((Object)(String.valueOf(this.getStyledText(String.valueOf(playerB) + "Decision:")) + this.lastPlayerDecisions.toString()));
        logger.info((Object)(String.valueOf(this.getStyledText(String.valueOf(playerB) + "Score:")) + this.lastPlayerScores.toString()));
        String playerAStrategy = ((Behavior)((List)firstPlayer.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType().toString();
        String playerBStrategy = ((Behavior)((List)lastPlayer.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType().toString();
        String playerAScore = String.valueOf(currentMatchInformation.getResultScore(firstPlayer));
        String playerBScore = String.valueOf(currentMatchInformation.getResultScore(lastPlayer));
        Agent winner = currentMatchInformation.getWinner();
        if (winner == firstPlayer) {
            logger.info((Object)("[<WIN:" + playerAScore + ">" + playerA + "(" + this.trimStrategyBehaviorName(playerAStrategy) + ")" + "\u00d7<LOSE:" + playerBScore + ">" + playerB + "(" + this.trimStrategyBehaviorName(playerBStrategy) + ")" + "]"));
        } else if (winner == lastPlayer) {
            logger.info((Object)("[<LOSE:" + playerAScore + ">" + playerA + "(" + this.trimStrategyBehaviorName(playerAStrategy) + ")" + "\u00d7<WIN:" + playerBScore + ">" + playerB + "(" + this.trimStrategyBehaviorName(playerBStrategy) + ")" + "]"));
        } else {
            logger.info((Object)("[<DRAW:" + playerAScore + ">" + playerA + "(" + this.trimStrategyBehaviorName(playerAStrategy) + ")" + "\u00d7<DRAW:" + playerBScore + ">" + playerB + "(" + this.trimStrategyBehaviorName(playerBStrategy) + ")" + "]"));
        }
    }

    private void turnLog() {
        MatchInformation match = this.getCurrentMatchInformation();
        Agent first = match.getEntryPair().getFirstPlayer();
        this.firstPlayerDecisions.append(match.getRecentDecision(first).toString());
        this.firstPlayerScores.append(match.getRecentScore(first));
        Agent last = match.getEntryPair().getLastPlayer();
        this.lastPlayerDecisions.append(match.getRecentDecision(last).toString());
        this.lastPlayerScores.append(match.getRecentScore(last));
    }

    private void startMatchLog() {
        this.firstPlayerDecisions = new StringBuffer();
        this.lastPlayerDecisions = new StringBuffer();
        this.firstPlayerScores = new StringBuffer();
        this.lastPlayerScores = new StringBuffer();
        MatchInformation currentMatchInformation = this.getCurrentMatchInformation();
        Agent firstPlayer = currentMatchInformation.getEntryPair().getFirstPlayer();
        Agent lastPlayer = currentMatchInformation.getEntryPair().getLastPlayer();
        String playerA = firstPlayer.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
        String playerB = lastPlayer.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
        String playerAStrategy = ((Behavior)((List)firstPlayer.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType().toString();
        String playerBStrategy = ((Behavior)((List)lastPlayer.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType().toString();
        logger.info((Object)"");
        logger.info((Object)("[" + playerA + "(" + this.trimStrategyBehaviorName(playerAStrategy) + ")" + "\u00d7" + playerB + "(" + this.trimStrategyBehaviorName(playerBStrategy) + ")" + "]"));
    }

    private String trimStrategyBehaviorName(String strategyTypeName) {
        int start = strategyTypeName.lastIndexOf(46) + 1;
        int last = strategyTypeName.lastIndexOf("StrategyBehavior");
        return strategyTypeName.substring(start, last);
    }

    private String getStyledText(String text) {
        int length = 20;
        int textLength = text.length();
        StringBuffer result = new StringBuffer(text);
        int i = 0;
        while (i < length - textLength) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }
}

