/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.model.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.besp.model.fmfw.informations.MessageInformation;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.model.behavior.AbstractManageContestBehavior;
import org.boxed_economy.ipd.model.information.ContestInformation;
import org.boxed_economy.ipd.model.information.MatchInformation;
import org.boxed_economy.ipd.model.information.MatchPairInformation;
import org.boxed_economy.ipd.model.information.MatchPairTableInformation;

public class ManageContestBehavior
extends AbstractManageContestBehavior {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.ipd.model.behavior.ManageContestBehavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void setNextEntryAction() {
        if (this.getAgent().getRelations(IPDModel.RELATIONTYPE_EntryRelation).size() > 0) {
            this.getAgent().removeRelations(IPDModel.RELATIONTYPE_EntryRelation);
        }
        MatchPairTableInformation pairTable = this.getMatchPairTableInformation();
        MatchPairInformation currentMatchPair = pairTable.getNextPair();
        this.getAgent().putInformation((Information)IPDModel.INFORMATIONTYPE_CurrentMatchInformation, (Information)new MatchInformation(currentMatchPair));
        this.getAgent().addRelation(IPDModel.RELATIONTYPE_EntryRelation, currentMatchPair.getFirstPlayer());
        this.getAgent().addRelation(IPDModel.RELATIONTYPE_EntryRelation, currentMatchPair.getLastPlayer());
    }

    protected void startMatchAction() {
        this.sendInformation(IPDModel.RELATIONTYPE_SelfRelation, IPDModel.BEHAVIORTYPE_ConductMatchBehavior, IPDModel.INFORMATIONTYPE_StartSignalInformation, (Information)new MessageInformation("Start!"), false);
    }

    protected void recordMatchResultAction() {
        MatchInformation matchInformation = (MatchInformation)this.getReceivedInformation();
        this.getCurrentContestInformation().registMatch(matchInformation);
    }

    protected void reportContestResultAction() {
        this.sendInformation(IPDModel.RELATIONTYPE_PlayerRelation, IPDModel.BEHAVIORTYPE_ReceiveResultBehavior, IPDModel.INFORMATIONTYPE_ContestResultInformation, this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_CurrentContestInformation), false);
        this.contestLog();
    }

    protected void prepareNextContextAction() {
        this.getMatchPairTableInformation().toNextContest();
        IntegerInformation currentCount = (IntegerInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_ContestCountInformation);
        this.getAgent().putInformation((Information)IPDModel.INFORMATIONTYPE_ContestCountInformation, (Information)new IntegerInformation(currentCount.getValue() + 1));
        this.getAgent().putInformation((Information)IPDModel.INFORMATIONTYPE_CurrentContestInformation, (Information)new ContestInformation());
    }

    protected boolean hasNextPair(Event e) {
        return this.getMatchPairTableInformation().hasNextPair();
    }

    protected boolean hasNotNextPair(Event e) {
        return !this.hasNextPair(e);
    }

    private MatchPairTableInformation getMatchPairTableInformation() {
        return (MatchPairTableInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_MatchPairTableInformation);
    }

    private ContestInformation getCurrentContestInformation() {
        return (ContestInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_CurrentContestInformation);
    }

    private void contestLog() {
        IntegerInformation contestCount = (IntegerInformation)this.getAgent().getInformation((Information)IPDModel.INFORMATIONTYPE_ContestCountInformation);
        ContestInformation contestInformation = this.getCurrentContestInformation();
        Collection allPlayers = this.getWorld().getAgents(IPDModel.AGENTTYPE_PlayerAgent);
        int totalScoreSum = 0;
        List strategies = IPDModel.BEHAVIORTYPE_StrategyBehavior.getChildren();
        HashMap<Object, Integer> strategyCounts = new HashMap<Object, Integer>();
        Iterator<Object> i = strategies.iterator();
        while (i.hasNext()) {
            strategyCounts.put(i.next(), new Integer(0));
        }
        logger.info((Object)"");
        logger.info((Object)"****************************************************************");
        logger.info((Object)(String.valueOf(contestCount.getValue() + 1) + "th Contest Result"));
        logger.info((Object)"");
        logger.info((Object)"--------------------Point of Agent on the contest------------------");
        logger.info((Object)("|" + this.getStyledText("Name") + "|" + this.getStyledText("Behavior") + "|" + this.getStyledText("GainPoint") + "|" + this.getStyledText("TotalPoint") + "|"));
        i = allPlayers.iterator();
        while (i.hasNext()) {
            Agent player = (Agent)i.next();
            IntegerInformation totalScore = (IntegerInformation)player.getInformation((Information)IPDModel.INFORMATIONTYPE_ScoreInformation);
            int contestScore = contestInformation.getContestScore(player);
            BehaviorType strategy = ((Behavior)((List)player.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType();
            String strategyName = this.trimStrategyBehaviorName(strategy.toString());
            String name = player.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
            Integer current = (Integer)strategyCounts.get(strategy);
            strategyCounts.put(strategy, new Integer(current + 1));
            logger.info((Object)("|" + this.getStyledText(name) + "|" + this.getStyledText(strategyName) + "|" + this.getStyledText(String.valueOf(contestScore)) + "|" + this.getStyledText(String.valueOf(totalScore)) + "|"));
            totalScoreSum += totalScore.getValue();
        }
        logger.info((Object)"");
        logger.info((Object)"--------------------------Average-------------------------------");
        logger.info((Object)("GainScoreAverage:" + contestInformation.getAverageScore()));
        logger.info((Object)("TotalScoreAverage:" + totalScoreSum / allPlayers.size()));
        logger.info((Object)"");
        logger.info((Object)"---------------------Number of each strategy----------------------");
        i = strategyCounts.keySet().iterator();
        while (i.hasNext()) {
            BehaviorType strategy = (BehaviorType)i.next();
            Integer count = (Integer)strategyCounts.get(strategy);
            logger.info((Object)(String.valueOf(this.getStyledText(this.trimStrategyBehaviorName(strategy.toString()))) + ":" + count));
        }
        logger.info((Object)"****************************************************************");
    }

    private String trimStrategyBehaviorName(String strategyTypeName) {
        int start = strategyTypeName.lastIndexOf(46) + 1;
        int last = strategyTypeName.lastIndexOf("StrategyBehavior");
        return strategyTypeName.substring(start, last);
    }

    private String getStyledText(String text) {
        int length = 10;
        int textLength = text.length();
        StringBuffer result = new StringBuffer(text);
        int i = 0;
        while (i < length - textLength) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }
}

