/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.model.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.AbstractInformation;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.ipd.model.information.MatchInformation;
import org.boxed_economy.ipd.model.information.WinnerListInformation;

public class ContestInformation
extends AbstractInformation {
    private HashMap winners = new HashMap();
    private List matches = new ArrayList();
    private HashMap scores = new HashMap();
    private List sortedAgents;
    private boolean isFinished = false;

    public void registMatch(MatchInformation match) {
        if (this.isFinished) {
            throw new ModelException("this contest is already finished" + (Object)((Object)this));
        }
        this.matches.add(match);
        Agent winner = match.getWinner();
        Agent loser = match.getLoser();
        if (winner != null) {
            ArrayList<Agent> winnerList = (ArrayList<Agent>)this.winners.get(loser);
            if (winnerList == null) {
                winnerList = new ArrayList<Agent>();
                this.winners.put(loser, winnerList);
            }
            winnerList.add(winner);
        }
        this.addScore(match, match.getEntryPair().getFirstPlayer());
        this.addScore(match, match.getEntryPair().getLastPlayer());
    }

    public WinnerListInformation getHighScorePlayers(Agent player) {
        int targetScore;
        Agent lastAgent;
        int lastAgentScore;
        this.isFinished = true;
        if (this.sortedAgents == null) {
            ArrayList allAgents = new ArrayList(this.scores.keySet());
            Collections.sort(allAgents, new AgentComparatorWithScore());
            this.sortedAgents = allAgents;
        }
        List headAgents = this.sortedAgents.subList(0, Collections.binarySearch(this.sortedAgents, player, new AgentComparatorWithScore()));
        int lastIndex = headAgents.size() - 1;
        while (!headAgents.isEmpty() && (lastAgentScore = ((Integer)this.scores.get(lastAgent = (Agent)headAgents.get(lastIndex))).intValue()) == (targetScore = ((Integer)this.scores.get(player)).intValue())) {
            headAgents.remove(lastIndex);
            --lastIndex;
        }
        return new WinnerListInformation(headAgents);
    }

    public WinnerListInformation getStrongerPlayers(Agent player) {
        this.isFinished = true;
        List winners = (List)this.winners.get(player);
        if (winners == null) {
            return new WinnerListInformation(new ArrayList());
        }
        return new WinnerListInformation(winners);
    }

    public int getContestScore(Agent player) {
        Integer score = (Integer)this.scores.get(player);
        return score;
    }

    public int getAverageScore() {
        Collection scores = this.scores.values();
        int sum = 0;
        Iterator i = scores.iterator();
        while (i.hasNext()) {
            Integer score = (Integer)i.next();
            sum += score.intValue();
        }
        if (sum == 0) {
            return 0;
        }
        return sum / scores.size();
    }

    private void addScore(MatchInformation match, Agent player) {
        Integer score = (Integer)this.scores.get(player);
        score = score == null ? new Integer(match.getResultScore(player)) : new Integer(score + match.getResultScore(player));
        this.scores.put(player, score);
    }

    public static void main(String[] args) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(2));
        set.add(new Integer(3));
        Integer san = new Integer(3);
        set.add(san);
        set.add(new Integer(3));
        set.add(new Integer(4));
        ArrayList list = new ArrayList(set);
        ArrayList<Integer> tailSet = new ArrayList<Integer>(set.tailSet(san));
        ArrayList<Integer> headSet = new ArrayList<Integer>(set.headSet(san));
        boolean a = false;
    }

    class AgentComparatorWithScore
    implements Comparator {
        AgentComparatorWithScore() {
        }

        public int compare(Object o1, Object o2) {
            Integer score1 = (Integer)ContestInformation.this.scores.get(o1);
            Integer score2 = (Integer)ContestInformation.this.scores.get(o2);
            return -1 * score1.compareTo(score2);
        }
    }
}

