/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.model.information;

import java.util.LinkedList;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.AbstractInformation;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.ipd.model.information.DecisionInformation;
import org.boxed_economy.ipd.model.information.MatchPairInformation;

public class MatchInformation
extends AbstractInformation {
    private MatchPairInformation entryPair;
    private LinkedList firstPlayerDecisions = new LinkedList();
    private LinkedList lastPlayerDecisions = new LinkedList();
    private int firstPlayerScore = 0;
    private int lastPlayerScore = 0;
    private int recentFirstPlayerScore = 0;
    private int recentSecondPlayerScore = 0;
    private Agent winner;

    public MatchInformation(MatchPairInformation entryPair) {
        this.entryPair = entryPair;
    }

    public MatchPairInformation getEntryPair() {
        return this.entryPair;
    }

    public void memoryDecision(Agent player, DecisionInformation decision) {
        if (player == this.entryPair.getFirstPlayer()) {
            this.firstPlayerDecisions.add(decision);
        } else if (player == this.entryPair.getLastPlayer()) {
            this.lastPlayerDecisions.add(decision);
        } else {
            throw new ModelException("this agent is not entry player" + player);
        }
        if (this.hasTurnFinished()) {
            this.recentFirstPlayerScore = this.calculateScore((DecisionInformation)((Object)this.firstPlayerDecisions.getLast()), (DecisionInformation)((Object)this.lastPlayerDecisions.getLast()));
            this.recentSecondPlayerScore = this.calculateScore((DecisionInformation)((Object)this.lastPlayerDecisions.getLast()), (DecisionInformation)((Object)this.firstPlayerDecisions.getLast()));
            this.firstPlayerScore += this.recentFirstPlayerScore;
            this.lastPlayerScore += this.recentSecondPlayerScore;
        }
    }

    public boolean hasTurnFinished() {
        return !this.firstPlayerDecisions.isEmpty() && this.firstPlayerDecisions.size() == this.lastPlayerDecisions.size();
    }

    public DecisionInformation getRecentDecision(Agent player) {
        if (player == this.entryPair.getFirstPlayer()) {
            return (DecisionInformation)((Object)this.firstPlayerDecisions.getLast());
        }
        if (player == this.entryPair.getLastPlayer()) {
            return (DecisionInformation)((Object)this.lastPlayerDecisions.getLast());
        }
        throw new ModelException("this agent is not entry player" + player);
    }

    public int getRecentScore(Agent player) {
        if (player == this.entryPair.getFirstPlayer()) {
            return this.recentFirstPlayerScore;
        }
        if (player == this.entryPair.getLastPlayer()) {
            return this.recentSecondPlayerScore;
        }
        throw new ModelException("this agent is not entry player" + player);
    }

    public int getResultScore(Agent player) {
        if (!this.hasTurnFinished()) {
            throw new ModelException("this match is not completed" + (Object)((Object)this));
        }
        if (player == this.entryPair.getFirstPlayer()) {
            return this.firstPlayerScore;
        }
        if (player == this.entryPair.getLastPlayer()) {
            return this.lastPlayerScore;
        }
        throw new ModelException("this agent is not entry player" + player);
    }

    public Agent getWinner() {
        if (!this.hasTurnFinished()) {
            throw new ModelException("this match is not completed" + (Object)((Object)this));
        }
        if (this.firstPlayerScore > this.lastPlayerScore) {
            return this.entryPair.getFirstPlayer();
        }
        if (this.firstPlayerScore < this.lastPlayerScore) {
            return this.entryPair.getLastPlayer();
        }
        return null;
    }

    public Agent getLoser() {
        if (!this.hasTurnFinished()) {
            throw new ModelException("this match is not completed" + (Object)((Object)this));
        }
        if (this.firstPlayerScore < this.lastPlayerScore) {
            return this.entryPair.getFirstPlayer();
        }
        if (this.firstPlayerScore > this.lastPlayerScore) {
            return this.entryPair.getLastPlayer();
        }
        return null;
    }

    private int calculateScore(DecisionInformation mineDecision, DecisionInformation opponentDecision) {
        String mine = mineDecision.getDecision();
        String opponent = opponentDecision.getDecision();
        if (mine.equals("C") && opponent.equals("C")) {
            return 3;
        }
        if (mine.equals("D") && opponent.equals("D")) {
            return 1;
        }
        if (mine.equals("C") && opponent.equals("D")) {
            return 0;
        }
        if (mine.equals("D") && opponent.equals("C")) {
            return 5;
        }
        throw new ModelException("Invalid Desicion : mine=" + mine + " opponent=" + opponent);
    }
}

