/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.ipd.presentation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.ipd.model.IPDModel;
import org.boxed_economy.ipd.presentation.ImageProvider;

class IPDBattlePanel
extends JPanel {
    private ImageIcon playerIcon;
    private ImageIcon opponentIcon;
    private Agent player;
    private Agent opponent;
    private BehaviorType playerStrategy;
    private BehaviorType opponentStrategy;
    private boolean isRock = false;

    public IPDBattlePanel() {
        Image playerImage = ImageProvider.getInstance().getImage("org/boxed_economy/ipd/presentation/player.gif");
        this.playerIcon = new ImageIcon(playerImage);
        Image opponentImage = ImageProvider.getInstance().getImage("org/boxed_economy/ipd/presentation/opponent.gif");
        this.opponentIcon = new ImageIcon(opponentImage);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.initializePanel(g);
        this.paintCurrentBattle(g);
    }

    public void setPlayers(Agent player, Agent opponent) {
        this.player = player;
        this.opponent = opponent;
    }

    private void initializePanel(Graphics g) {
        this.setBackground(Color.white);
        g.setFont(new Font("Verdana", 0, 10));
    }

    private void paintCurrentBattle(Graphics g) {
        if (this.player != null) {
            BehaviorType playerStrategy = this.getStrategyType(this.player);
            BehaviorType opponentStrategy = this.getStrategyType(this.opponent);
            if (this.isRock) {
                this.playerIcon.paintIcon(this, g, 20, 20);
                g.drawString(this.getPlayerName(this.player), 30, 66);
                this.drawLineWithShadow(g, 55, 27, 68, 19);
                this.drawStringWithShadow(g, this.getStrategyName(this.playerStrategy), 60, 40);
                g.setColor(Color.RED);
                g.setFont(new Font("Verdana", 0, 11));
                g.drawString("VS", 132, 42);
                g.drawString("VS", 131, 42);
                g.setColor(Color.BLACK);
                g.setFont(new Font("Verdana", 0, 10));
                this.opponentIcon.paintIcon(this, g, 200, 20);
                g.drawString(this.getPlayerName(this.opponent), 210, 66);
                this.drawLineWithShadow(g, 155, 27, 68, 19);
                this.drawStringWithShadow(g, this.getStrategyName(this.opponentStrategy), 160, 40);
            } else {
                this.playerStrategy = playerStrategy;
                this.opponentStrategy = opponentStrategy;
                this.playerIcon.paintIcon(this, g, 20, 20);
                g.drawString(this.getPlayerName(this.player), 30, 66);
                this.drawLineWithShadow(g, 55, 27, 68, 19);
                this.drawStringWithShadow(g, this.getStrategyName(playerStrategy), 60, 40);
                g.setColor(Color.RED);
                g.setFont(new Font("Verdana", 0, 11));
                g.drawString("VS", 132, 42);
                g.drawString("VS", 131, 42);
                g.setColor(Color.BLACK);
                g.setFont(new Font("Verdana", 0, 10));
                this.opponentIcon.paintIcon(this, g, 200, 20);
                g.drawString(this.getPlayerName(this.opponent), 210, 66);
                this.drawLineWithShadow(g, 155, 27, 68, 19);
                this.drawStringWithShadow(g, this.getStrategyName(opponentStrategy), 160, 40);
            }
        }
    }

    public void setIsRock(boolean b) {
        this.isRock = b;
    }

    private void drawLineWithShadow(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.BLACK);
        g.drawRect(x, y, width, height);
        g.setColor(Color.GRAY);
        g.drawLine(x + width + 1, y + 1, x + width + 1, y + height + 1);
        g.drawLine(x + 1, y + height + 1, x + width, y + height + 1);
    }

    private void drawStringWithShadow(Graphics g, String s, int x, int y) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawString(s, x + 2, y);
        g.setColor(Color.GRAY);
        g.drawString(s, x + 1, y);
        g.setColor(Color.BLACK);
        g.drawString(s, x, y);
    }

    public String getPlayerName(Agent player) {
        return player.getInformation((Information)IPDModel.INFORMATIONTYPE_NameInformation).toString();
    }

    public String getStrategyName(BehaviorType strategy) {
        StringBuffer sb = new StringBuffer(strategy.getName());
        sb.delete(0, sb.lastIndexOf(".") + 1).toString();
        sb.delete(sb.indexOf("StrategyBehavior"), sb.length());
        return sb.toString();
    }

    private BehaviorType getStrategyType(Agent player) {
        return ((Behavior)((List)player.getBehaviorsRecursively(IPDModel.BEHAVIORTYPE_StrategyBehavior)).get(0)).getType();
    }
}

